/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.CloudInstanceDataWebServiceResolverHelper;
import com.singularity.ee.agent.resolver.IIPAddressResolver;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.logging.ILogger;
import java.util.Set;

public class CloudInstanceIPAddressResolver
implements IIPAddressResolver {
    protected final ILogger logger;
    private final Object resolutionInfoLock = new Object();
    private final CloudInstanceDataWebServiceResolverHelper helper;
    private Set<String> ipAddresses;

    public CloudInstanceIPAddressResolver(ILogger logger) {
        this.logger = logger;
        this.helper = new CloudInstanceDataWebServiceResolverHelper(this, logger);
        this.cleanUpAfterRun();
    }

    @Override
    public String getName() {
        return "Cloud Instance IP Address Resolver";
    }

    @Override
    public boolean resolveAsync() {
        return true;
    }

    @Override
    public void cancelResolution() {
        this.helper.cancelResolution();
    }

    @Override
    public void cleanUpAfterRun() {
        this.helper.cleanUpAfterRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resolutionSucceeded() {
        Object object = this.resolutionInfoLock;
        synchronized (object) {
            return this.ipAddresses != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getIPAddresses() {
        Object object = this.resolutionInfoLock;
        synchronized (object) {
            return this.ipAddresses != null ? (String[])CollectionHelper.collectionToArray(this.ipAddresses, (Object[])new String[this.ipAddresses.size()]) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.debug(this.getName() + " is running");
        try {
            CloudInstanceDataWebServiceResolverHelper.WebServiceResponse response = this.helper.connectToDataWebServiceAndParseResponse(false, true);
            if (response != null && response.ipAddresses != null) {
                for (String ipAddress : response.ipAddresses) {
                    this.parseIPAddressMetaDataResponse(ipAddress);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception during " + this.getName() + " resolution", (Throwable)e);
        }
        finally {
            this.logger.debug(this.getName() + " finished running");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseIPAddressMetaDataResponse(String ip) {
        if (ip != null && ip.trim().length() > 0) {
            Object object = this.resolutionInfoLock;
            synchronized (object) {
                if (this.ipAddresses == null) {
                    this.ipAddresses = CollectionHelper.createHashSet((int)3);
                }
                this.logger.info(this.getName() + " found IP address [" + ip + "]");
                this.ipAddresses.add(ip);
            }
        }
    }
}

