/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.IResolver;
import com.singularity.ee.util.httpclient.HttpExecutionRequest;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.httpclient.HttpOperation;
import com.singularity.ee.util.httpclient.IHttpClientWrapper;
import com.singularity.ee.util.httpclient.SimpleHttpClientWrapper;
import com.singularity.ee.util.logging.ILogger;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class CloudInstanceDataWebServiceResolverHelper {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private final Object cancelResolutionLock = new Object();
    private final IResolver resolver;
    private final ILogger logger;
    private final URL userDataURL;
    private final URL internalIpAddressURL;
    private final URL externalIpAddressURL;
    private final URL externalHostnameURL;
    private IHttpClientWrapper httpClient;
    private CountDownLatch cancelResolutionLatch;

    CloudInstanceDataWebServiceResolverHelper(IResolver resolver, ILogger logger) {
        this.resolver = resolver;
        this.logger = logger;
        this.userDataURL = CloudInstanceDataWebServiceResolverHelper.getLatestUserDataVersionURL();
        this.externalIpAddressURL = CloudInstanceDataWebServiceResolverHelper.getLatestMetaDataVersionURL("public-ipv4");
        this.externalHostnameURL = CloudInstanceDataWebServiceResolverHelper.getLatestMetaDataVersionURL("public-hostname");
        this.internalIpAddressURL = CloudInstanceDataWebServiceResolverHelper.getLatestMetaDataVersionURL("local-ipv4");
    }

    private static URL getLatestMetaDataVersionURL(String target) {
        try {
            return new URL("http://169.254.169.254/latest/meta-data/" + target);
        }
        catch (Exception e) {
            throw new IllegalStateException("Latest version of meta data web service URL is incorrect");
        }
    }

    private static URL getLatestUserDataVersionURL() {
        try {
            return new URL("http://169.254.169.254/latest/user-data");
        }
        catch (Exception e) {
            throw new IllegalStateException("Latest version of user-supplied data web service URL is incorrect");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelResolution() {
        block9: {
            CountDownLatch currentCancelResolutionLatch;
            Object object = this.cancelResolutionLock;
            synchronized (object) {
                currentCancelResolutionLatch = this.cancelResolutionLatch;
            }
            try {
                if (!currentCancelResolutionLatch.await(60L, TimeUnit.SECONDS)) break block9;
                object = this.cancelResolutionLock;
                synchronized (object) {
                    if (this.httpClient != null) {
                        this.httpClient.shutdown();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpAfterRun() {
        Object object = this.cancelResolutionLock;
        synchronized (object) {
            this.cancelResolutionLatch = new CountDownLatch(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebServiceResponse connectToDataWebServiceAndParseResponse(boolean fetchUserData, boolean fetchIPData) {
        Object object;
        WebServiceResponse response = new WebServiceResponse();
        try {
            object = this.cancelResolutionLock;
            synchronized (object) {
                this.httpClient = new SimpleHttpClientWrapper(10000);
                this.cancelResolutionLatch.countDown();
            }
            if (fetchUserData) {
                response.userData = this.fetchData(this.userDataURL);
            }
            if (fetchIPData) {
                String[] ipAddresses = new String[]{this.fetchData(this.externalHostnameURL), this.fetchData(this.internalIpAddressURL), this.fetchData(this.externalIpAddressURL)};
                response.ipAddresses = ipAddresses;
            }
        }
        finally {
            object = this.cancelResolutionLock;
            synchronized (object) {
                if (this.httpClient != null) {
                    this.httpClient.shutdown();
                }
            }
        }
        return response;
    }

    private String fetchData(URL url) {
        HttpExecutionRequest request = new HttpExecutionRequest(url.toString(), null, HttpOperation.GET);
        HttpExecutionResponse response = this.httpClient.executeHttpOperation(request, (ILogger)new DowngradeIOExceptionLogger(this.logger));
        if (response.isExceptionHappened() || response.isStatusNotOk()) {
            this.logger.info(this.resolver.getName() + " could not reach cloud instance data web service");
            return null;
        }
        return response.getResponseBody();
    }

    private static class DowngradeIOExceptionLogger
    implements ILogger {
        private final ILogger logger;

        public DowngradeIOExceptionLogger(ILogger logger) {
            this.logger = logger;
        }

        public void debug(String msg, Throwable t) {
            this.logger.debug(msg, t);
        }

        public void debug(String msg) {
            this.logger.debug(msg);
        }

        public void error(String msg, Throwable t) {
            if (t instanceof IOException) {
                this.logger.debug(msg, t);
            } else {
                this.logger.error(msg, t);
            }
        }

        public void error(String msg) {
            this.logger.error(msg);
        }

        public void fatal(String msg, Throwable t) {
            if (t instanceof IOException) {
                this.logger.debug(msg, t);
            } else {
                this.logger.fatal(msg, t);
            }
        }

        public void fatal(String msg) {
            this.logger.fatal(msg);
        }

        public void info(String msg, Throwable t) {
            if (t instanceof IOException) {
                this.logger.debug(msg, t);
            } else {
                this.logger.info(msg, t);
            }
        }

        public void info(String msg) {
            this.logger.info(msg);
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        public void trace(String msg, Throwable t) {
            this.logger.trace(msg, t);
        }

        public void trace(String msg) {
            this.logger.trace(msg);
        }

        public void warn(String msg, Throwable t) {
            if (t instanceof IOException) {
                this.logger.debug(msg, t);
            } else {
                this.logger.warn(msg, t);
            }
        }

        public void warn(String msg) {
            this.logger.warn(msg);
        }
    }

    public static class WebServiceResponse {
        public String userData;
        public String[] ipAddresses;
    }
}

