/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.AgentSystemProperties;
import com.singularity.ee.agent.resolver.IResolver;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.system.SystemUtils;

public abstract class ADefaultResolver
extends AgentSystemProperties
implements IResolver {
    protected final ILogger logger;

    protected ADefaultResolver(ILogger logger) {
        super(logger);
        this.logger = logger;
    }

    @Override
    public abstract String getName();

    @Override
    public abstract void run();

    @Override
    public abstract boolean resolveAsync();

    @Override
    public void cleanUpAfterRun() {
    }

    @Override
    public abstract boolean resolutionSucceeded();

    @Override
    public void cancelResolution() {
    }

    protected String getProperty(String envVariableName, String sysPropertyKey, String propertyName) {
        try {
            String envVarValue = SystemUtils.getenv((String)envVariableName);
            if (envVarValue != null) {
                String envVarLog = this.getName() + " found env variable [" + envVariableName + "] for " + propertyName + " [%s]";
                if (!envVariableName.equals("APPDYNAMICS_AGENT_ACCOUNT_ACCESS_KEY") && !envVariableName.equals("APPDYNAMICS_CONTROLLER_KEYSTORE_PASSWORD")) {
                    this.logger.info(String.format(envVarLog, envVarValue));
                } else {
                    this.logger.info(String.format(envVarLog, "****"));
                }
                return envVarValue;
            }
            String sysPropValue = SystemUtils.getProperty((String)sysPropertyKey);
            if (sysPropValue != null) {
                String sysPropLog = this.getName() + " found system property [" + sysPropertyKey + "] for " + propertyName + " [%s]";
                if (!sysPropertyKey.equals("appdynamics.agent.accountAccessKey") && !sysPropertyKey.equals("appdynamics.controller.keystorePassword")) {
                    this.logger.info(String.format(sysPropLog, sysPropValue));
                } else {
                    this.logger.info(String.format(sysPropLog, "****"));
                }
                return sysPropValue;
            }
        }
        catch (Throwable e) {
            this.logger.warn("Error in " + this.getName() + " reading environment variable/system property ", e);
        }
        return null;
    }
}

