/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.crashdetect;

import com.singularity.ee.agent.crashdetect.ACrashAnalyzerImpl;
import com.singularity.ee.util.logging.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class IBMCrashAnalyzer
extends ACrashAnalyzerImpl {
    private static final String SIGNAL_IDENTIFICATION_PREFIX = "1TISIGINFO";
    private static final String DATE_TIME_IDENTIFICATION_PREFIX = "1TIDATETIME";
    private static final String DATE_IDENTIFICATION = "Date:";

    IBMCrashAnalyzer(File hotspotErrorFile, ILogger logger) {
        super(hotspotErrorFile, logger);
    }

    @Override
    public String getCrashReason() {
        if (this.crashReason == null) {
            this.readAndAnalyzeCrashFile();
        }
        return this.crashReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readAndAnalyzeCrashFile() {
        if (!this.crashFileRead) {
            this.crashReason = "Unknown";
            BufferedReader reader = null;
            try {
                String nextLineRead;
                reader = this.getReader();
                while ((nextLineRead = reader.readLine()) != null) {
                    block20: {
                        if (nextLineRead.startsWith(SIGNAL_IDENTIFICATION_PREFIX)) {
                            this.crashReason = nextLineRead.substring(SIGNAL_IDENTIFICATION_PREFIX.length()).trim();
                        } else if (nextLineRead.startsWith(DATE_TIME_IDENTIFICATION_PREFIX) && (nextLineRead = nextLineRead.substring(DATE_TIME_IDENTIFICATION_PREFIX.length()).trim()).startsWith(DATE_IDENTIFICATION)) {
                            nextLineRead = nextLineRead.substring(DATE_IDENTIFICATION.length()).trim();
                            try {
                                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd 'at' HH:mm:ss");
                                Date parsedDateAndTime = dateFormat.parse(nextLineRead);
                                this.crashDateTime = parsedDateAndTime.getTime();
                            }
                            catch (ParseException e) {
                                if (this.logger == null) break block20;
                                this.logger.warn(String.format("%s caught trying to parse date/time %s from crash log", e, nextLineRead), (Throwable)e);
                            }
                        }
                    }
                    if (this.crashDateTime <= 0L || this.crashReason.equals("Unknown")) continue;
                    break;
                }
            }
            catch (Throwable t) {
                if (this.logger != null) {
                    this.logger.error(t.toString(), t);
                }
            }
            finally {
                block22: {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable t) {
                            if (this.logger == null) break block22;
                            this.logger.error(t.toString(), t);
                        }
                    }
                }
            }
            this.crashFileRead = true;
        }
    }

    @Override
    public boolean matchesPID(long pid) {
        return true;
    }
}

