/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.crashdetect;

import com.singularity.ee.agent.crashdetect.ACrashAnalyzerImpl;
import com.singularity.ee.util.logging.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class HotspotCrashAnalyzer
extends ACrashAnalyzerImpl {
    private static final String TIME_START = "time: ";

    HotspotCrashAnalyzer(File hotspotErrorFile, ILogger logger) {
        super(hotspotErrorFile, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readAndAnalyzeCrashFile() {
        if (!this.crashFileRead) {
            block22: {
                this.crashReason = "Unknown";
                BufferedReader reader = null;
                try {
                    String nextLineRead;
                    StringBuilder sb = new StringBuilder();
                    reader = this.getReader();
                    int lineNumber = 0;
                    while ((nextLineRead = reader.readLine()) != null) {
                        if (++lineNumber < 4) continue;
                        if ((nextLineRead = nextLineRead.substring(1).trim()).length() <= 0) break;
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(nextLineRead);
                    }
                    if (sb.length() > 0) {
                        this.crashReason = sb.toString();
                    }
                    if (nextLineRead == null) break block22;
                    while ((nextLineRead = reader.readLine()) != null) {
                        if (!(nextLineRead = nextLineRead.trim()).startsWith(TIME_START)) continue;
                        if ((nextLineRead = nextLineRead.substring(TIME_START.length()).trim()).length() > 0) {
                            try {
                                SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
                                Date parsedDateAndTime = dateFormat.parse(nextLineRead);
                                this.crashDateTime = parsedDateAndTime.getTime();
                            }
                            catch (ParseException e) {
                                if (this.logger != null) {
                                    this.logger.warn(String.format("%s caught trying to parse date/time %s from crash log", e, nextLineRead), (Throwable)e);
                                }
                            }
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    if (this.logger != null) {
                        this.logger.error(t.toString(), t);
                    }
                }
                finally {
                    block23: {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable t) {
                                if (this.logger == null) break block23;
                                this.logger.error(t.toString(), t);
                            }
                        }
                    }
                }
            }
            this.crashFileRead = true;
        }
    }

    @Override
    public boolean matchesPID(long pid) {
        String startOfPid;
        int indexOfComma;
        int indexOfPidKeyword;
        boolean bReturn = true;
        this.readAndAnalyzeCrashFile();
        if (this.crashReason != null && !this.crashReason.equals("Unknown") && (indexOfPidKeyword = this.crashReason.indexOf("pid=")) >= 0 && (indexOfComma = (startOfPid = this.crashReason.substring(indexOfPidKeyword + 4)).indexOf(44)) > 0) {
            long testPid = Long.parseLong(startOfPid.substring(0, indexOfComma));
            bReturn = pid == testPid;
        }
        return bReturn;
    }
}

