/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.configuration.impl;

import com.singularity.ee.agent.configuration.impl.AgentSchedulerThreadPoolExecutorFactory;
import com.singularity.ee.agent.configuration.impl.ThreadPoolIdentifier;
import com.singularity.ee.agent.configuration.spi.AgentThreadListener;
import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.safety.ICustomAction;
import com.singularity.ee.util.javaspecific.scheduler.IAgentRunnableMeasurer;
import com.singularity.ee.util.javaspecific.scheduler.IAgentSchedulerMeasurerProvider;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import java.util.List;

public class AgentSchedulerManagerInstance
extends ThreadPoolIdentifier
implements IAgentSchedulerManager {
    private AgentSchedulerThreadPoolExecutorFactory schedulerThreadPoolExecutorFactory;
    private IAgentScheduledThreadPoolExecutor globalScheduler;
    private IAgentScheduledThreadPoolExecutor btRegistration;
    private IAgentScheduledThreadPoolExecutor metricReporter;
    private IAgentScheduledThreadPoolExecutor metricAggregator;
    private IAgentScheduledThreadPoolExecutor outlierEvaluator;
    private IAgentScheduledThreadPoolExecutor sampler;
    private IAgentScheduledThreadPoolExecutor coalescableScheduler;
    private IAgentScheduledThreadPoolExecutor sampleProcessor;
    private IAgentScheduledThreadPoolExecutor hotspotProcessor;
    private IAgentScheduledThreadPoolExecutor topBackendsProcessor;
    private IAgentScheduledThreadPoolExecutor proxyAsyncMsgProcessor;
    private IAgentScheduledThreadPoolExecutor proxyAsyncReqProcessor;
    private IAgentScheduledThreadPoolExecutor bciTransformProcessor;
    private IAgentScheduledThreadPoolExecutor proxyControlReqProcessor;
    private IAgentScheduledThreadPoolExecutor cloudInstanceIdGetterScheduler;
    private IAgentScheduledThreadPoolExecutor proxyShutdownReqProcessor;
    private IAgentScheduledThreadPoolExecutor transientEventChannelScheduler;
    private volatile IAgentRunnableMeasurer runnableMeasurer;
    public static final int DEFAULT_APPDYNAMICS_METRIC_REPORTING_THREAD_POOL_SIZE_PROPERTY_VALUE = 2;
    public static final int DEFAULT_APPDYNAMICS_METRIC_REPORTING_THREAD_POOL_SIZE_PROPERTY_MAX_VALUE = 8;
    private static final String APPDYNAMICS_METRIC_REPORTING_THREAD_POOL_SIZE_PROPERTY = "appdynamics.metric.reporting.thread.pool.size";
    private static final int GLOBAL_THREAD_POOL_SIZE = 2;
    private static final int CLOUD_INSTANCE_ID_GETTER_THREAD_POOL_SIZE = 3;
    private final List<AgentThreadListener> listeners = CollectionHelper.createCopyOnWriteList();

    public AgentSchedulerManagerInstance() {
    }

    public AgentSchedulerManagerInstance(ILogger logger, AgentSchedulerThreadPoolExecutorFactory schedulerThreadPoolExecutorFactory) {
        this.init(logger, schedulerThreadPoolExecutorFactory);
    }

    @Override
    public void initProxySchedulers(int asyncMsgThreadCount, int asyncReqThreadCount, int shutdownReqThreadCount, ILogger logger) {
        this.proxyAsyncMsgProcessor = this.createScheduler(asyncMsgThreadCount, "AD Thread Pool-ProxyAsyncMsg", logger);
        this.proxyAsyncReqProcessor = this.createScheduler(asyncReqThreadCount, "AD Thread Pool-ProxyAsyncReq", logger);
        this.proxyShutdownReqProcessor = this.createScheduler(shutdownReqThreadCount, "AD Thread Pool-ProxyShutdownReq", logger);
    }

    @Override
    public void initProxyCoreScheduler(int reqThreadCount, ILogger logger, AgentSchedulerThreadPoolExecutorFactory schedulerThreadPoolExecutorFactory) {
        this.schedulerThreadPoolExecutorFactory = schedulerThreadPoolExecutorFactory;
        schedulerThreadPoolExecutorFactory.init(logger);
        this.proxyControlReqProcessor = this.createScheduler(reqThreadCount, "AD Thread Pool-ProxyControlReq", logger);
    }

    @Override
    public void init(ILogger logger, AgentSchedulerThreadPoolExecutorFactory schedulerThreadPoolExecutorFactory) {
        this.schedulerThreadPoolExecutorFactory = schedulerThreadPoolExecutorFactory;
        schedulerThreadPoolExecutorFactory.init(logger);
        this.btRegistration = this.globalScheduler = this.createScheduler(2, "AD Thread Pool-Global", logger);
        this.outlierEvaluator = this.globalScheduler;
        this.metricAggregator = this.metricReporter = this.createScheduler(this.getMetricReportingThreadPoolSize(logger), "AD Thread-Metric Reporter", logger);
        this.transientEventChannelScheduler = this.createScheduler(1, "AD Thread-Transient Event Channel Poller", logger);
        this.hotspotProcessor = this.createScheduler(1, "AD Thread-Hotspot Processor", logger);
        this.topBackendsProcessor = this.createScheduler(1, "AD Thread-Top Backends Processor", logger);
        this.cloudInstanceIdGetterScheduler = schedulerThreadPoolExecutorFactory.createNonPauseExecutor(3, logger, "AD Cloud Instance Id Getter-", this.listeners);
    }

    @Override
    public void initSnapshotServiceSamplerPool(int samplerPoolSize, int maxSamplerTasksAllowed, BoundsPolicy policy, ICustomAction customAction, ILogger logger) {
        this.sampler = this.createScheduler(samplerPoolSize, maxSamplerTasksAllowed, policy, customAction, "AD Thread Pool-CSS", logger);
        this.sampler.setGuardAgainstNanoTimeInconsistencies();
        this.coalescableScheduler = this.createScheduler(1, "AD Thread Pool-Coalescable_CS_Scheduler", logger);
        this.coalescableScheduler.setGuardAgainstNanoTimeInconsistencies();
    }

    @Override
    public void initSnapshotServiceSampleProcessorPool(int sampleProcessorPoolSize, int maxSampleProcessorTasksAllowed, BoundsPolicy policy, ICustomAction customAction, ILogger logger) {
        this.sampleProcessor = this.createScheduler(sampleProcessorPoolSize, maxSampleProcessorTasksAllowed, policy, customAction, "AD Thread Pool-CGG", logger);
        this.sampleProcessor.setGuardAgainstNanoTimeInconsistencies();
    }

    @Override
    public synchronized void initBCITransformProcessor(int poolSize, ILogger logger) {
        if (this.bciTransformProcessor == null) {
            this.bciTransformProcessor = this.createScheduler(poolSize, "AD Thread-BCI Transform Processor", logger);
        }
    }

    @Override
    public synchronized void terminateBCITransformProcessor() {
        if (this.bciTransformProcessor != null) {
            this.bciTransformProcessor.shutdown();
            this.bciTransformProcessor = null;
        }
    }

    @Override
    public void shutdownNow() {
        RuntimeException exception = null;
        if (this.globalScheduler != null) {
            try {
                this.globalScheduler.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down global scheduler", e);
            }
            this.globalScheduler = null;
        }
        if (this.btRegistration != null) {
            try {
                this.btRegistration.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down bt registration scheduler", e);
            }
            this.btRegistration = null;
        }
        if (this.metricReporter != null) {
            try {
                this.metricReporter.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down metric reporter", e);
            }
            this.metricReporter = null;
        }
        if (this.metricAggregator != null) {
            try {
                this.metricAggregator.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down metric aggregator", e);
            }
            this.metricAggregator = null;
        }
        if (this.outlierEvaluator != null) {
            try {
                this.outlierEvaluator.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down outlier evaluator", e);
            }
            this.outlierEvaluator = null;
        }
        if (this.sampler != null) {
            try {
                this.sampler.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down sampler", e);
            }
            this.sampler = null;
        }
        if (this.sampleProcessor != null) {
            try {
                this.sampleProcessor.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down sample processor", e);
            }
            this.sampleProcessor = null;
        }
        if (this.hotspotProcessor != null) {
            try {
                this.hotspotProcessor.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down hotspot processor", e);
            }
            this.hotspotProcessor = null;
        }
        if (null != this.transientEventChannelScheduler) {
            try {
                this.transientEventChannelScheduler.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down transient event channel scheduler", e);
            }
            this.transientEventChannelScheduler = null;
        }
        if (null != this.topBackendsProcessor) {
            try {
                this.topBackendsProcessor.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down top backends processor scheduler", e);
            }
            this.topBackendsProcessor = null;
        }
        if (null != this.proxyAsyncMsgProcessor) {
            try {
                this.proxyAsyncMsgProcessor.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down proxy async message processor", e);
            }
            this.proxyAsyncMsgProcessor = null;
        }
        if (null != this.proxyAsyncReqProcessor) {
            try {
                this.proxyAsyncReqProcessor.shutdownNow();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down proxy async request processor", e);
            }
            this.proxyAsyncReqProcessor = null;
        }
        if (null != this.cloudInstanceIdGetterScheduler) {
            try {
                this.cloudInstanceIdGetterScheduler.shutdown();
            }
            catch (Throwable e) {
                exception = new RuntimeException("Failed to shut down cloud instance id request scheduler", e);
            }
            this.cloudInstanceIdGetterScheduler = null;
        }
        if (null != this.proxyShutdownReqProcessor) {
            try {
                this.proxyShutdownReqProcessor.shutdownNow();
            }
            catch (Exception e) {
                exception = new RuntimeException("Failed to shut down proxy shutdown request processor", e);
            }
            this.proxyShutdownReqProcessor = null;
        }
        if (exception != null) {
            throw exception;
        }
        for (AgentThreadListener listener : this.listeners) {
            listener.onShutdown();
        }
    }

    @Override
    public void addThreadListener(AgentThreadListener listener) {
        this.listeners.add(listener);
    }

    private IAgentScheduledThreadPoolExecutor createScheduler(int poolSize, String name, ILogger logger) {
        IAgentScheduledThreadPoolExecutor returnObject = this.schedulerThreadPoolExecutorFactory.createExecutor(poolSize, name, this.listeners, logger);
        returnObject.setAgentSchedulerMeasurerProvider((IAgentSchedulerMeasurerProvider)this);
        return returnObject;
    }

    private IAgentScheduledThreadPoolExecutor createScheduler(int poolSize, int maxTasksAllowed, BoundsPolicy policy, ICustomAction customAction, String name, ILogger logger) {
        IAgentScheduledThreadPoolExecutor returnObject = this.schedulerThreadPoolExecutorFactory.createExecutor(poolSize, maxTasksAllowed, policy, customAction, name, this.listeners, logger);
        returnObject.setAgentSchedulerMeasurerProvider((IAgentSchedulerMeasurerProvider)this);
        return returnObject;
    }

    @Override
    public IAgentScheduledExecutorService getTransientEventChannelScheduler() {
        if (null == this.transientEventChannelScheduler) {
            throw new IllegalStateException("Transient Event Channel Scheduler not initialized");
        }
        return this.transientEventChannelScheduler;
    }

    @Override
    public boolean isAgentGlobalSchedulerInitialized() {
        return this.globalScheduler != null;
    }

    @Override
    public IAgentScheduledThreadPoolExecutor getAgentGlobalScheduler() {
        if (this.globalScheduler == null) {
            throw new IllegalStateException("Agent Scheduler not initialized");
        }
        return this.globalScheduler;
    }

    @Override
    public IAgentScheduledExecutorService getBtRegistration() {
        if (this.btRegistration == null) {
            throw new IllegalStateException("BT Registration not initialized");
        }
        return this.btRegistration;
    }

    @Override
    public IAgentScheduledExecutorService getAgentOutlierEvaluator() {
        if (this.outlierEvaluator == null) {
            throw new IllegalStateException("Outlier Evaluator not initialized");
        }
        return this.outlierEvaluator;
    }

    @Override
    public IAgentScheduledThreadPoolExecutor getSampler() {
        if (this.sampler == null) {
            throw new IllegalStateException("Sampler not initialized");
        }
        return this.sampler;
    }

    @Override
    public IAgentScheduledThreadPoolExecutor getCoalescableScheduler() {
        if (this.coalescableScheduler == null) {
            throw new IllegalStateException("Sampler not initialized");
        }
        return this.coalescableScheduler;
    }

    @Override
    public IAgentScheduledThreadPoolExecutor getBCITransformProcessor() {
        if (this.bciTransformProcessor == null) {
            throw new IllegalStateException("BCITransformProcessor not initialized");
        }
        return this.bciTransformProcessor;
    }

    @Override
    public IAgentScheduledThreadPoolExecutor getSampleProcessor() {
        if (this.sampleProcessor == null) {
            throw new IllegalStateException("Sample Processor not initialized");
        }
        return this.sampleProcessor;
    }

    @Override
    public IAgentScheduledExecutorService getAgentHotspotScheduler() {
        if (this.hotspotProcessor == null) {
            throw new IllegalStateException("Hotspot processor not initialized");
        }
        return this.hotspotProcessor;
    }

    @Override
    public IAgentScheduledExecutorService getAgentMetricAggregator() {
        if (this.metricAggregator == null) {
            throw new IllegalStateException("Metric Aggregator not initialized");
        }
        return this.metricAggregator;
    }

    @Override
    public IAgentScheduledExecutorService getAgentMetricReporter() {
        if (this.metricReporter == null) {
            throw new IllegalStateException("Metric Reporter not initialized");
        }
        return this.metricReporter;
    }

    @Override
    public IAgentScheduledExecutorService getTopBackendsProcessor() {
        if (this.topBackendsProcessor == null) {
            throw new IllegalStateException("Top Backends Processor not initialized");
        }
        return this.topBackendsProcessor;
    }

    @Override
    public IAgentScheduledExecutorService getProxyAsyncMsgProcessor() {
        if (this.proxyAsyncMsgProcessor == null) {
            throw new IllegalStateException("Proxy Async Msg Processor not initialized");
        }
        return this.proxyAsyncMsgProcessor;
    }

    @Override
    public IAgentScheduledExecutorService getProxyAsyncReqProcessor() {
        if (this.proxyAsyncReqProcessor == null) {
            throw new IllegalStateException("Proxy Async Req Processor not initialized");
        }
        return this.proxyAsyncReqProcessor;
    }

    @Override
    public IAgentScheduledExecutorService getProxyShutdownReqProcessor() {
        if (this.proxyShutdownReqProcessor == null) {
            throw new IllegalStateException("Proxy Shutdown Req Processor not initialized");
        }
        return this.proxyShutdownReqProcessor;
    }

    @Override
    public IAgentScheduledExecutorService getProxyControlReqProcessor() {
        if (this.proxyControlReqProcessor == null) {
            throw new IllegalStateException("Proxy Control Req Processor not initialized");
        }
        return this.proxyControlReqProcessor;
    }

    public void setAgentRunnableMeasurer(IAgentRunnableMeasurer runnableMeasurer) {
        this.runnableMeasurer = runnableMeasurer;
    }

    public IAgentRunnableMeasurer getAgentRunnableMeasurer() {
        return this.runnableMeasurer;
    }

    @Override
    public IAgentScheduledExecutorService getCloudInstanceIdGetterScheduler() {
        return this.cloudInstanceIdGetterScheduler;
    }

    protected int getMetricReportingThreadPoolSize(ILogger logger) {
        int poolSize = 2;
        String poolSizeValue = System.getProperty(APPDYNAMICS_METRIC_REPORTING_THREAD_POOL_SIZE_PROPERTY);
        if (poolSizeValue != null) {
            try {
                poolSize = Integer.parseInt(poolSizeValue);
                if (poolSize < 2) {
                    poolSize = 2;
                } else if (poolSize > 8) {
                    poolSize = 8;
                }
            }
            catch (NumberFormatException nfe) {
                logger.error(String.format("Invalid %s property value: %s", APPDYNAMICS_METRIC_REPORTING_THREAD_POOL_SIZE_PROPERTY, poolSizeValue));
            }
        }
        return poolSize;
    }
}

