/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.configuration.identity;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.agent.configuration.identity.AgentIdentity;
import com.singularity.ee.agent.configuration.identity.IIdentityManager;
import com.singularity.ee.agent.configuration.identity.XMLIdentityManagerHelper;
import com.singularity.ee.agent.configuration.impl.ConfigException;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.agent.resolver.IControllerInfoResolver;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.httpclient.TrustManagerShouldDoDefaultValidation;
import com.singularity.ee.util.javaspecific.mutable.ADBoolean;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseException;
import com.singularity.ee.util.xml.XMLParseUtility;
import com.singularity.ee.util.xml.XMLWriteException;
import com.singularity.ee.util.xml.XMLWriter;
import java.io.File;
import java.io.InputStream;

public class XMLIdentityManager
implements IIdentityManager,
IControllerInfoResolver {
    public static final String SYSTEM_IDENTITY_XML = "system-identity.xml";
    public static final String CONTROLLER_HOST_INFO_XML = "controller-info.xml";
    public static final String CONF = "conf";
    private final ILogger logger;
    private String[] identityConfigFilePath;
    private Document identityConfigXmlDoc;
    private AgentIdentity agentIdentity;
    private ControllerInfo.ControllerInfoMemento controllerInfoMemento = null;

    public XMLIdentityManager(ILogger logger) {
        this.logger = logger;
    }

    public XMLIdentityManager(ILogger logger, String ... identityFilePath) {
        this(logger);
        this.identityConfigFilePath = identityFilePath;
    }

    @Override
    public AgentIdentity configureInstance(String ... xmlFile) throws ConfigException {
        AgentIdentity returnObject = null;
        this.identityConfigFilePath = xmlFile;
        for (String nextFile : xmlFile) {
            if (nextFile == null || !XMLIdentityManagerHelper.checkIfFileExistsOrDotNet(nextFile)) continue;
            try {
                this.identityConfigXmlDoc = XMLParseUtility.getXMLDocument((String)nextFile, (String)"Agent Identity XML File", (ILogger)this.logger);
            }
            catch (XMLParseException e) {
                this.logger.error("Error reading identity xml file", (Throwable)e);
                throw new ConfigException("Error reading identity xml file", e);
            }
            AgentIdentity latestReturnObject = this.getBootStrapInfo(this.identityConfigXmlDoc.getDocumentElement());
            if (returnObject == null) {
                returnObject = latestReturnObject;
            } else {
                returnObject.mergeNewAgentIdentity(latestReturnObject);
            }
            if (returnObject.isComplete()) break;
        }
        if (returnObject == null) {
            throw new ConfigException("Could not find identity xml file at:" + StringOperations.convertToCommaSeparateString((String[])xmlFile));
        }
        if (this.isPartiallyResolved(returnObject)) {
            this.saveToMemento(returnObject);
        }
        return returnObject;
    }

    @Override
    public AgentIdentity getAgentIdentity(InputStream inStream) throws ConfigException {
        try {
            Document xmlDoc = XMLParseUtility.getXMLDocument((InputStream)inStream, (String)"Config Bootstrap Input XML Stream", (ILogger)this.logger);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Config bootstrap doc generated:" + xmlDoc.getDocumentElement());
            }
            return this.getBootStrapInfo(xmlDoc.getDocumentElement());
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    private AgentIdentity getBootStrapInfo(Element bootStrapElement) {
        String componentId;
        String nodeId;
        String controllerHost = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"controller-host");
        this.logger.debug("Controller host read -" + controllerHost);
        if (controllerHost == null || "".equals(controllerHost)) {
            this.logger.warn(this.getName() + " found invalid controller host information [" + controllerHost + "] in controller-info.xml; Please specify a valid value if it is not already set in system properties.");
        } else if (controllerHost.startsWith("$")) {
            this.logger.warn(this.getName() + " found invalid controller host information [" + controllerHost + "] in controller-info.xml; Please specify a valid value if it is not already set in system properties.");
        } else {
            this.logger.info(this.getName() + " found controller host [" + controllerHost + "]");
        }
        int controllerPort = XMLParseUtility.safeParseIntValue((Element)bootStrapElement, (String)"controller-port");
        if (controllerPort == -1) {
            this.logger.warn(this.getName() + " found invalid controller port information [" + XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"controller-port") + "] in controller-info.xml; Please specify a valid value if it is not already set in system properties.");
        } else {
            this.logger.info(this.getName() + " found controller port [" + controllerPort + "]");
        }
        String sslenabled = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"controller-ssl-enabled");
        String filename = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"controller-keystore-filename");
        String password = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"controller-keystore-password");
        String useEncryptedCredentials = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"use-encrypted-credentials");
        String credentialStoreFilename = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"credential-store-filename");
        String credentialStorePassword = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"credential-store-password");
        String credentialStoreFormat = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"credential-store-format");
        String useSslClientAuth = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"use-ssl-client-auth");
        String asymmetricKeysStoreFilename = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"asymmetric-keystore-filename");
        String asymmetricKeysStorePassword = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"asymmetric-keystore-password");
        String asymmetricKeyPassword = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"asymmetric-key-password");
        String asymmetricKeyAlias = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"asymmetric-key-alias");
        TrustManagerShouldDoDefaultValidation sslValidation = this.parseTrustManagerValidation(bootStrapElement);
        AgentIdentity bootStrapInfo = new AgentIdentity(controllerHost, controllerPort);
        bootStrapInfo.setControllerSSLEnabled(ADBoolean.parse((String)sslenabled));
        if (!StringOperations.isEmpty((String)useEncryptedCredentials)) {
            bootStrapInfo.setUseEncryptedCredentials(Boolean.valueOf(useEncryptedCredentials));
        }
        if (!StringOperations.isEmpty((String)useSslClientAuth)) {
            bootStrapInfo.setUseSslClientAuth(Boolean.valueOf(useSslClientAuth));
        }
        bootStrapInfo.setKeystoreFileName(filename);
        bootStrapInfo.setKeystorePassword(password);
        bootStrapInfo.setCredentialStoreFileName(credentialStoreFilename);
        bootStrapInfo.setCredentialStorePassword(credentialStorePassword);
        bootStrapInfo.setCredentialStoreFormat(credentialStoreFormat);
        bootStrapInfo.setAsymmetricKeysStoreFilename(asymmetricKeysStoreFilename);
        bootStrapInfo.setAsymmetricKeysStorePassword(asymmetricKeysStorePassword);
        bootStrapInfo.setAsymmetricKeyPassword(asymmetricKeyPassword);
        bootStrapInfo.setAsymmetricKeyAlias(asymmetricKeyAlias);
        String machineInstanceId = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"instance-id");
        if (machineInstanceId != null && machineInstanceId.length() > 0) {
            bootStrapInfo.setMachineInstanceID(machineInstanceId);
        }
        if ((nodeId = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"node-id")) != null && nodeId.length() > 0) {
            bootStrapInfo.setNodeID(nodeId);
        }
        if ((componentId = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"tier-id")) != null && componentId.length() > 0) {
            bootStrapInfo.setComponentID(componentId);
        }
        bootStrapInfo.setValidation(sslValidation);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Config bootstrap info read :" + bootStrapInfo);
        }
        return bootStrapInfo;
    }

    private void saveToMemento(AgentIdentity agentIdentity) {
        this.controllerInfoMemento = new ControllerInfo.ControllerInfoMemento(agentIdentity.getControllerHost(), Integer.toString(agentIdentity.getControllerPort()), agentIdentity.isControllerSSLEnabled() != null ? agentIdentity.isControllerSSLEnabled().toString() : "", agentIdentity.getKeystoreFileName(), agentIdentity.getKeystorePassword(), Boolean.toString(agentIdentity.getUseEncryptedCredentialsPrimitive()), agentIdentity.getCredentialStoreFileName(), agentIdentity.getCredentialStorePassword(), agentIdentity.getCredentialStoreFormat(), agentIdentity.getUseSslClientAuth() != null ? agentIdentity.getUseSslClientAuth().toString() : "", agentIdentity.getAsymmetricKeysStoreFilename(), agentIdentity.getAsymmetricKeysStorePassword(), agentIdentity.getAsymmetricKeyPassword(), agentIdentity.getAsymmetricKeyAlias(), agentIdentity.getValidation());
    }

    private boolean isPartiallyResolved(AgentIdentity agentIdentity) {
        boolean infoPartiallyResolved = false;
        if (StringOperations.isEmpty((String)agentIdentity.getControllerHost()) || agentIdentity.getControllerHost().startsWith("$") || agentIdentity.getControllerPort() == -1 || StringOperations.isEmpty((String)agentIdentity.getKeystoreFileName()) || StringOperations.isEmpty((String)agentIdentity.getKeystorePassword()) || agentIdentity.getUseEncryptedCredentials() == null || StringOperations.isEmpty((String)agentIdentity.getCredentialStoreFileName()) || StringOperations.isEmpty((String)agentIdentity.getCredentialStorePassword()) || StringOperations.isEmpty((String)agentIdentity.getCredentialStoreFormat()) || agentIdentity.getUseSslClientAuth() == null || StringOperations.isEmpty((String)agentIdentity.getAsymmetricKeysStoreFilename()) || StringOperations.isEmpty((String)agentIdentity.getAsymmetricKeysStorePassword()) || StringOperations.isEmpty((String)agentIdentity.getAsymmetricKeyPassword()) || StringOperations.isEmpty((String)agentIdentity.getAsymmetricKeyAlias()) || agentIdentity.getControllerSSLEnabled() == null || agentIdentity.getValidation() == TrustManagerShouldDoDefaultValidation.UNSPECIFIED) {
            infoPartiallyResolved = true;
        }
        return infoPartiallyResolved;
    }

    private TrustManagerShouldDoDefaultValidation parseTrustManagerValidation(Element bootStrapElement) {
        String sslValidationString = XMLParseUtility.getTextForTagForElement((Node)bootStrapElement, (String)"force-default-ssl-certificate-validation");
        TrustManagerShouldDoDefaultValidation sslValidation = null;
        try {
            if (!StringOperations.isEmpty((String)sslValidationString)) {
                sslValidation = (TrustManagerShouldDoDefaultValidation)EnumHelper.getEnum(TrustManagerShouldDoDefaultValidation.class, (String)sslValidationString.toUpperCase());
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("Invalid value for %s: %s.  Exception: %s", "force-default-ssl-certificate-validation", sslValidationString, e), (Throwable)e);
            sslValidation = null;
        }
        if (sslValidation == null) {
            sslValidation = TrustManagerShouldDoDefaultValidation.UNSPECIFIED;
        }
        return sslValidation;
    }

    @Override
    public void saveAgentIdentity(AgentIdentity instanceInfo) throws ConfigException {
        XMLWriter writer;
        try {
            writer = new XMLWriter();
        }
        catch (ParserConfigurationException e) {
            this.logger.error("Could not write agent identity to disk", (Throwable)e);
            throw new ConfigException("Could not write agent identity to disk", e);
        }
        this.identityConfigXmlDoc = writer.getDocument();
        Element instanceElement = writer.getDocument().createElement("instance");
        this.identityConfigXmlDoc.appendChild((Node)instanceElement);
        writer.addTextNode(instanceElement, "instance-id", instanceInfo.getMachineInstanceID());
        if (instanceInfo.getNodeID() != null) {
            writer.addTextNode(instanceElement, "node-id", instanceInfo.getNodeID());
        }
        if (instanceInfo.getComponentID() != null) {
            writer.addTextNode(instanceElement, "tier-id", instanceInfo.getComponentID());
        }
        writer.addTextNode(instanceElement, "controller-host", instanceInfo.getControllerHost());
        writer.addTextNode(instanceElement, "controller-port", String.valueOf(instanceInfo.getControllerPort()));
        writer.addTextNode(instanceElement, "controller-ssl-enabled", instanceInfo.isControllerSSLEnabled() != null ? instanceInfo.isControllerSSLEnabled().toString() : "");
        try {
            if (this.identityConfigFilePath.length > 0) {
                if (new File(this.identityConfigFilePath[0]).exists()) {
                    new File(this.identityConfigFilePath[0]).delete();
                }
                writer.saveToFile(this.identityConfigFilePath[0]);
            }
        }
        catch (XMLWriteException e) {
            this.logger.error("Could not write agent identity to disk", (Throwable)e);
            throw new ConfigException("Could not write agent identity to disk", e);
        }
    }

    @Override
    public ControllerInfo getControllerHostInfo() {
        if (this.resolutionSucceeded()) {
            return new ControllerInfo(this.agentIdentity.getControllerHost(), this.agentIdentity.getControllerPort(), this.agentIdentity.isControllerSSLEnabled(), this.agentIdentity.getKeystoreFileName(), this.agentIdentity.getKeystorePassword(), this.agentIdentity.getUseEncryptedCredentialsPrimitive(), this.agentIdentity.getCredentialStoreFileName(), this.agentIdentity.getCredentialStorePassword(), this.agentIdentity.getCredentialStoreFormat(), this.agentIdentity.getUseSslClientAuth(), this.agentIdentity.getAsymmetricKeysStoreFilename(), this.agentIdentity.getAsymmetricKeysStorePassword(), this.agentIdentity.getAsymmetricKeyPassword(), this.agentIdentity.getAsymmetricKeyAlias(), this.agentIdentity.getValidation());
        }
        return null;
    }

    @Override
    public ControllerInfo.ControllerInfoMemento getControllerInfoMemento() {
        return this.controllerInfoMemento;
    }

    @Override
    public String getName() {
        return "XML Controller Info Resolver";
    }

    @Override
    public boolean resolveAsync() {
        return false;
    }

    @Override
    public void cleanUpAfterRun() {
    }

    @Override
    public void run() {
        this.logger.debug(this.getName() + " is running");
        try {
            this.agentIdentity = this.configureInstance(this.identityConfigFilePath);
            if (this.resolutionSucceeded()) {
                this.logger.info(this.getName() + " found valid config [" + this.agentIdentity + "]");
            } else {
                this.agentIdentity = null;
            }
        }
        catch (ConfigException e) {
            this.logger.warn("Error reading agent identity", (Throwable)e);
        }
        this.logger.debug(this.getName() + " finished running");
    }

    @Override
    public boolean resolutionSucceeded() {
        return this.agentIdentity != null && this.controllerInfoMemento == null;
    }

    @Override
    public boolean resolutionPartiallyCompleted() {
        return this.controllerInfoMemento != null;
    }

    @Override
    public void cancelResolution() {
    }
}

