/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.configuration.channel;

import com.singularity.ee.agent.configuration.channel.AgentConfigManager;
import com.singularity.ee.agent.configuration.channel.IConfigurationChannel;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentScheduledFuture;

public class AgentConfigurationRefreshTask
implements IAgentRunnable {
    private final ILogger logger;
    private final IConfigurationChannel channel;
    private IAgentScheduledFuture future;
    private AgentConfigManager configManager;

    protected AgentConfigurationRefreshTask(IConfigurationChannel channel, ILogger logger) {
        this.channel = channel;
        this.logger = logger;
    }

    public void setFuture(IAgentScheduledFuture future) {
        this.future = future;
    }

    public void setConfigManager(AgentConfigManager manager) {
        this.configManager = manager;
    }

    public void run() {
        try {
            if (this.channel.getConfigurationContext().shouldStopPolling() && this.future != null) {
                this.configManager.nonInterruptingDisable();
                this.logger.debug("Cancelling the SystemAgentPolling future task for Machine Id " + this.channel.getMachineId());
            } else {
                this.channel.refreshConfiguration();
            }
        }
        catch (Throwable t) {
            this.logger.error("Error occurred while attempting to refresh configuration", t);
        }
    }
}

