/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.timeskewhandling;

import com.singularity.ee.agent.appagent.kernel.controller.JavaAgentRESTRequestFactory;
import com.singularity.ee.agent.commonservices.timeskewhandling.AControllerTimeSkewHandler;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.GetCurrentTimeRequest;
import com.singularity.ee.rest.controller.request.spi.IAppAgentRequest;
import com.singularity.ee.util.clock.ClockUtilsHelper;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.logging.ILogger;

public class ControllerTimeSkewCommunicator {
    private AControllerTimeSkewHandler handler;
    private ILogger ccLogger;

    public ControllerTimeSkewCommunicator(AControllerTimeSkewHandler inHandler) {
        this.handler = inHandler;
        this.ccLogger = inHandler.getLogger();
    }

    public boolean invoke() {
        GetCurrentTimeRequest request = JavaAgentRESTRequestFactory.getCurrentTimeRequest(this.handler.getControllerHost(), this.handler.getControllerPort(), this.handler.getMachineID(), this.ccLogger);
        if (this.handler.getComponentNodeId() != null) {
            request.setComponentNodeId(this.handler.getComponentNodeId());
        }
        if (this.handler.getHttpClient() != null) {
            request.setHttpClient(this.handler.getHttpClient());
        }
        HttpExecutionResponse executionResponse = request.sendRequest();
        try {
            if (executionResponse.isExceptionHappened() || executionResponse.isStatusNotOk()) {
                this.ccLogger.error("Error response from controller: " + executionResponse.getExceptionMessage());
                return true;
            }
            GetCurrentTimeRequest response = JavaAgentRESTRequestFactory.getCurrentTimeResponse(executionResponse.getResponseBody(), this.ccLogger);
            if (response.isContextualLoggingEnabled()) {
                this.handler.logRequestResponse((IAppAgentRequest)request, (IAppAgentRequest)response);
            }
            if (response.isTimeStampAvailable()) {
                long controllerTimeStamp = response.getTimeStamp();
                if (this.ccLogger.isDebugEnabled()) {
                    this.ccLogger.debug("Controller Time Stamp " + ClockUtilsHelper.getDateFromLong((long)controllerTimeStamp));
                }
                this.handler.calculateSkew(controllerTimeStamp);
            } else {
                this.ccLogger.warn("Controller did not send back time stamp so cannot adjust for time skew!");
            }
        }
        catch (ResponseReadException e) {
            this.ccLogger.error("Error in reading response from controller " + (Object)((Object)e));
        }
        return false;
    }
}

