/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.timeskewhandling;

import com.singularity.ee.agent.commonservices.timeskewhandling.ControllerTimeSkewCommunicator;
import com.singularity.ee.agent.commonservices.timeskewhandling.spi.ControllerTimeSkewSnapshot;
import com.singularity.ee.agent.commonservices.timeskewhandling.spi.IControllerTimeSkewHandler;
import com.singularity.ee.rest.controller.request.spi.IAppAgentRequest;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.httpclient.SimpleHttpClientWrapper;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentAtomicLong;

public abstract class AControllerTimeSkewHandler
implements IAgentRunnable,
IControllerTimeSkewHandler {
    public static final long SKEW_CALCULATION_INTERVAL_MILLIS = 300000L;
    public static final long IGNORE_SKEW_MILLIS = 10000L;
    private final Object skewSnapshotLock = new Object();
    private final ILogger logger;
    private final IAgentAtomicLong skew = new AgentAtomicLongImpl();
    private volatile boolean agentLagging;

    public ILogger getLogger() {
        return this.logger;
    }

    public AControllerTimeSkewHandler(ILogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateSkew(long controllerTimestamp) {
        long currentTime = ClockUtils.getCurrentTime();
        long currentSkew = 0L;
        Object object = this.skewSnapshotLock;
        synchronized (object) {
            currentSkew = currentTime - controllerTimestamp;
            if (Math.abs(currentSkew) < 10000L) {
                this.skew.set(0L);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Agent timestamp: " + currentTime + "; Controller timestamp: " + controllerTimestamp + "; Ignoring skew less than " + 10000L + " msec. Skew value set to 0");
                }
            } else {
                this.agentLagging = currentTime < controllerTimestamp;
                long absCurrentSkew = Math.abs(currentSkew);
                this.skew.set(absCurrentSkew);
                this.logger.info("Agent timestamp: " + currentTime + "; Controller timestamp: " + controllerTimestamp + "; Skew value=" + absCurrentSkew + " msec; agentLagging=" + this.agentLagging);
            }
        }
    }

    public void run() {
        try {
            if (this.isSkewCheckDisabled()) {
                this.logger.info("Controller Time Skew Handler Run Aborted - Skew Check is Disabled");
                return;
            }
            if (new ControllerTimeSkewCommunicator(this).invoke()) {
                return;
            }
        }
        catch (Throwable e) {
            this.logger.error("Error getting current time from controller", e);
        }
    }

    @Override
    public long adjustWithSkew(long time) {
        time = this.agentLagging ? (time += this.skew.get()) : (time -= this.skew.get());
        return time;
    }

    @Override
    public boolean isTimeSkewed() {
        return this.getSkew().get() != 0L;
    }

    public IAgentAtomicLong getSkew() {
        return this.skew;
    }

    public boolean isAgentLagging() {
        return this.agentLagging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ControllerTimeSkewSnapshot getTimeSkewSnapshot() {
        ControllerTimeSkewSnapshot snapshot = new ControllerTimeSkewSnapshot();
        Object object = this.skewSnapshotLock;
        synchronized (object) {
            snapshot.isTimeSkewed = this.isTimeSkewed();
            snapshot.skew = this.getSkew().get();
            snapshot.isAgentLagging = this.isAgentLagging();
        }
        return snapshot;
    }

    protected String getComponentNodeId() {
        return null;
    }

    protected SimpleHttpClientWrapper getHttpClient() {
        return null;
    }

    public void logRequestResponse(IAppAgentRequest request, IAppAgentRequest response) {
    }

    protected abstract String getControllerHost();

    protected abstract int getControllerPort();

    protected abstract String getMachineID();

    protected abstract boolean isSkewCheckDisabled();
}

