/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration;

import com.singularity.ee.agent.commonservices.metricgeneration.IMetricGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.IMetricPostProcessor;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.MetricRegistrationException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.MetricSendException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.MetricsForTimeslice;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricData;
import com.singularity.ee.agent.debug.AgentDebugEventSenderProxy;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.collections.bounded.SharedBoundedConcurrentLinkedQueue;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MetricReporter
extends Observable
implements IAgentRunnable {
    private final AgentType agentType;
    private final IMetricGenerationService mgs;
    private IMetricPostProcessor metricPostProcessor = null;
    private final ConcurrentLinkedQueue<MetricsForTimeslice> unprocessedMetrics = new SharedBoundedConcurrentLinkedQueue(500);

    public MetricReporter(IMetricGenerationService mgs, AgentType agentType) {
        this.mgs = mgs;
        this.agentType = agentType;
    }

    public void setMetricPostProcessor(IMetricPostProcessor IMetricPostProcessor2) {
        this.metricPostProcessor = IMetricPostProcessor2;
    }

    public void collectMetrics(MetricsForTimeslice metrics) {
        if (this.mgs.getLogger().isTraceEnabled()) {
            this.mgs.getLogger().trace("collecting metrics");
        }
        if (this.metricPostProcessor != null) {
            metrics = this.metricPostProcessor.process(metrics);
        }
        while (CollectionHelper.queueSize(this.unprocessedMetrics) >= this.mgs.getMaxPublishQueueLength()) {
            MetricsForTimeslice removed = (MetricsForTimeslice)this.unprocessedMetrics.remove();
            this.mgs.getLogger().warn("Metric Reporter Queue full. Dropping metrics.");
            switch (this.agentType) {
                case APP_AGENT: {
                    AgentDebugEventSenderProxy.getInstance().sendMetricDebugEventDropped(removed);
                }
            }
        }
        this.unprocessedMetrics.add(metrics);
    }

    void clearQueue() {
        this.unprocessedMetrics.clear();
    }

    public void run() {
        try {
            if (!this.mgs.getSubscriber().isInitialized()) {
                return;
            }
            MetricsForTimeslice metricsForTimeslice = this.unprocessedMetrics.peek();
            while (metricsForTimeslice != null) {
                if (!this.mgs.isMetricDataRequest()) {
                    if (this.mgs.getLogger().isDebugEnabled()) {
                        this.mgs.getLogger().debug("Metrics request disabled, unprocessed metric queue is drained but will not be sent to controller");
                    }
                    this.unprocessedMetrics.poll();
                    return;
                }
                if (this.mgs.getSubscriber() != null) {
                    try {
                        ArrayList<AgentRawMetricData> registeredMetrics = new ArrayList<AgentRawMetricData>();
                        List<AgentRawMetricData> verifiedUnregisteredMetrics = this.mgs.separateUnregisteredMetrics(metricsForTimeslice, registeredMetrics);
                        List<AgentRawMetricData> successfullyRegisteredMetric = this.mgs.registerMetrics(verifiedUnregisteredMetrics);
                        CollectionHelper.addAll(registeredMetrics, (Collection)CollectionHelper.asList((Object[])metricsForTimeslice.getMetrics().getRegisteredMetrics()));
                        CollectionHelper.addAll(registeredMetrics, successfullyRegisteredMetric);
                        metricsForTimeslice.getMetrics().setRegisteredMetrics((AgentRawMetricData[])CollectionHelper.collectionToArray(registeredMetrics, (Object[])new AgentRawMetricData[registeredMetrics.size()]));
                        metricsForTimeslice.getMetrics().setUnregisteredMetrics(AgentRawMetricData.EMPTY_ARRAY);
                    }
                    catch (MetricRegistrationException e) {
                        this.mgs.getLogger().error("Error registering metrics", (Throwable)e);
                    }
                    this.mgs.getSubscriber().publish(metricsForTimeslice);
                    this.setChanged();
                    this.notifyObservers(metricsForTimeslice);
                    this.unprocessedMetrics.poll();
                } else {
                    this.unprocessedMetrics.poll();
                }
                metricsForTimeslice = this.unprocessedMetrics.peek();
            }
        }
        catch (MetricSendException mse) {
            this.mgs.getLogger().error("Error sending metrics - will requeue for later transmission", (Throwable)mse);
        }
        catch (Throwable e) {
            this.mgs.getLogger().error("Error reporting metrics", e);
        }
    }
}

