/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration;

import com.singularity.ee.agent.commonservices.IPropertyChangeListener;
import com.singularity.ee.agent.commonservices.metricgeneration.IMetricGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.MetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.MetricReporter;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AMetricAggregatorFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.IMetricAggregatorFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.IMetricSubscriber;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.MetricRegistrationException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.MetricsForTimeslice;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricData;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.IMetricReporterFactory;
import com.singularity.ee.agent.commonservices.timeskewhandling.spi.ControllerTimeSkewSnapshot;
import com.singularity.ee.agent.commonservices.timeskewhandling.spi.IControllerTimeSkewHandler;
import com.singularity.ee.agent.configuration.impl.AgentSchedulerManager;
import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;

public class MetricGenerationService
implements IPropertyChangeListener,
IMetricGenerationService {
    public static final Object METRIC_AGGREGATOR_RUN_END = new Object();
    public static final Object METRIC_AGGREGATOR_RUN_BEGIN = new Object();
    private static final String METRIC_INTERVAL_PROP_NAME = "appdynamics.metric.reporting.interval";
    private static final long MILLISECONDS_PER_MINUTE = 60000L;
    private final AMetricAggregatorFactory metricAggregatorFactory;
    private MetricAggregator metricAggregator;
    private final int aggregationFrequencyInMillis;
    public static int defaultReporterIntervalMs = 10000;
    public int reporterIntervalMs;
    private ILogger logger;
    private final MetricReporter metricReporter;
    private final IControllerTimeSkewHandler skewHandler;
    private final IAgentAtomicInteger maxPublishQueueLength;
    private final IAgentScheduledFuture metricsReporterScheduledFuture;
    private IAgentScheduledFuture metricAggregatorScheduledFuture;
    private boolean testMode;
    private long testModeMetricIDSequence;
    public static final String METRIC_DATA_REQUEST = "metric-data-request";
    public static final String METRIC_DATA_AGGREGATION = "metric-data-aggregation";
    private volatile boolean metricDataRequest = true;
    private volatile boolean metricDataAggregation = true;
    private volatile boolean blockMetricDataAggregation;
    private IMetricSubscriber subscriber;
    private final IAgentSchedulerManager schedulerManager;
    private final AgentType agentType;

    @Override
    public IMetricSubscriber getSubscriber() {
        return this.subscriber;
    }

    @Override
    public IControllerTimeSkewHandler getSkewHandler() {
        return this.skewHandler;
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public int getMaxPublishQueueLength() {
        return this.maxPublishQueueLength.get();
    }

    @Override
    public boolean isMetricDataRequest() {
        return this.metricDataRequest;
    }

    @Override
    public IMetricReporterFactory getMetricReporterFactory() {
        return this.metricAggregatorFactory;
    }

    public MetricGenerationService(IAgentAtomicInteger maxPublishQueueLength, int aggregationFrequencyInMillis, ILogger logger, IControllerTimeSkewHandler skewHandler, AgentType agentType, AMetricAggregatorFactory aggregatorFactory, boolean isServiceDisabled, IAgentSchedulerManager schedulerManager) {
        this.logger = logger;
        this.skewHandler = skewHandler;
        this.metricAggregatorFactory = aggregatorFactory;
        this.aggregationFrequencyInMillis = aggregationFrequencyInMillis;
        this.schedulerManager = schedulerManager;
        this.agentType = agentType;
        this.maxPublishQueueLength = maxPublishQueueLength;
        logger.info("Initialized with maxPublishQueueLength [" + maxPublishQueueLength + "], aggregationFrequencyInMillis [" + aggregationFrequencyInMillis + "]");
        this.metricReporter = new MetricReporter(this, agentType);
        this.reporterIntervalMs = this.getReportingIntervalMs();
        IAgentScheduledExecutorService metricsReporterScheduler = schedulerManager.getAgentMetricReporter();
        this.metricsReporterScheduledFuture = metricsReporterScheduler.scheduleAtFixedRate((IAgentRunnable)this.metricReporter, (long)this.reporterIntervalMs, (long)this.reporterIntervalMs, AgentTimeUnit.MILLISECONDS);
        IAgentScheduledExecutorService metricAggregatorScheduler = schedulerManager.getAgentMetricAggregator();
        this.metricAggregator = new MetricAggregator(this);
        long aggregatorDelay = Math.min(this.timeToNextMinuteBoundary(false, null), (long)aggregationFrequencyInMillis);
        this.metricAggregatorScheduledFuture = metricAggregatorScheduler.scheduleAtFixedRate((IAgentRunnable)this.metricAggregator, aggregatorDelay, (long)aggregationFrequencyInMillis, AgentTimeUnit.MILLISECONDS);
        this.switchMetricServiceDisabled(isServiceDisabled);
    }

    public MetricGenerationService(int maxInactiveTimeSlicesAllowed, int maxPublishQueueLength, int aggregationFrequencyInMillis, ILogger logger, IControllerTimeSkewHandler skewHandler, AgentType agentType, AMetricAggregatorFactory aggregatorFactory, boolean isServiceDisabled) {
        this((IAgentAtomicInteger)new AgentAtomicIntegerImpl(maxPublishQueueLength), aggregationFrequencyInMillis, logger, skewHandler, agentType, aggregatorFactory, isServiceDisabled, AgentSchedulerManager.getInstance());
    }

    private int getReportingIntervalMs() {
        int returnValue;
        block3: {
            returnValue = defaultReporterIntervalMs;
            String overrideReportingValue = SystemUtils.getProperty((String)METRIC_INTERVAL_PROP_NAME);
            if (overrideReportingValue != null) {
                try {
                    returnValue = Integer.parseInt(overrideReportingValue) * 1000;
                }
                catch (NumberFormatException e) {
                    if (this.logger == null) break block3;
                    this.logger.error(String.format("Invalid %s property value: %s", METRIC_INTERVAL_PROP_NAME, overrideReportingValue));
                }
            }
        }
        return returnValue;
    }

    @Override
    public void setMetricSubscriber(IMetricSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public void propertyChanged(String propertyName, String newPropertyValue) {
        if (propertyName.equals(METRIC_DATA_REQUEST)) {
            this.metricDataRequest = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)true);
        } else if (propertyName.equals(METRIC_DATA_AGGREGATION)) {
            this.metricDataAggregation = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)true);
        }
    }

    public void hotDisable() {
        this.subscriber.hotDisable();
        this.blockMetricDataAggregation = true;
        this.metricReporter.clearQueue();
        this.metricAggregatorFactory.clearAllAggregators();
    }

    public void hotEnable() {
        if (this.subscriber != null) {
            this.subscriber.hotEnable();
        }
        this.blockMetricDataAggregation = false;
    }

    public void switchMetricServiceDisabled(boolean isDisabled) {
        this.logger.info("Metric Service is : [" + (isDisabled ? "disabled" : "enabled") + "].");
        if (isDisabled) {
            this.hotDisable();
        } else {
            this.hotEnable();
        }
    }

    @Override
    public List<AgentRawMetricData> separateUnregisteredMetrics(MetricsForTimeslice metricsForTimeslice, List<AgentRawMetricData> registeredMetrics) {
        AgentRawMetricData[] unregisteredMetrics = metricsForTimeslice.getMetrics().getUnregisteredMetrics();
        ArrayList<AgentRawMetricData> verifiedUnregisteredMetrics = new ArrayList<AgentRawMetricData>();
        if (unregisteredMetrics.length > 0) {
            for (AgentRawMetricData unregisteredMetric : unregisteredMetrics) {
                if (unregisteredMetric.getMetricIdentifier().getId() == 0L) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("adding unregistered metric " + unregisteredMetric.getMetricIdentifier().getName());
                    }
                    verifiedUnregisteredMetrics.add(unregisteredMetric);
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("adding registered metric " + unregisteredMetric.getMetricIdentifier().getName());
                }
                registeredMetrics.add(unregisteredMetric);
            }
        }
        return verifiedUnregisteredMetrics;
    }

    @Override
    public boolean isTestMode() {
        return this.testMode;
    }

    @Override
    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    @Override
    public IMetricAggregatorFactory getMetricAggregatorFactory() {
        return this.metricAggregatorFactory;
    }

    @Override
    public MetricReporter getMetricReporter() {
        return this.metricReporter;
    }

    @Override
    public boolean isBlockMetricDataAggregation() {
        return this.blockMetricDataAggregation;
    }

    @Override
    public boolean isMetricDataAggregation() {
        return this.metricDataAggregation;
    }

    @Override
    public List<AgentRawMetricData> registerMetrics(List<AgentRawMetricData> verifiedUnregisteredMetrics) throws MetricRegistrationException {
        if (this.testMode) {
            for (AgentRawMetricData metric : verifiedUnregisteredMetrics) {
                metric.getMetricIdentifier().setId(++this.testModeMetricIDSequence);
            }
            return verifiedUnregisteredMetrics;
        }
        if (verifiedUnregisteredMetrics != null && verifiedUnregisteredMetrics.size() > 0) {
            return this.subscriber.registerMetrics(verifiedUnregisteredMetrics, (IMetricAggregatorFactory)this.metricAggregatorFactory);
        }
        return CollectionHelper.emptySerializableList();
    }

    @Override
    public void addObserverForMetricAggregator(Observer listener) {
        this.metricAggregator.addObserver(listener);
    }

    @Override
    public void removeObserverForMetricAggregator(Observer listener) {
        this.metricAggregator.deleteObserver(listener);
    }

    @Override
    public void shutdown() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("shutdown metric generation service.");
        }
        this.hotDisable();
        if (this.metricAggregatorScheduledFuture != null) {
            this.metricAggregatorScheduledFuture.cancel(true);
        }
        if (this.metricsReporterScheduledFuture != null) {
            this.metricsReporterScheduledFuture.cancel(true);
        }
    }

    protected void finalize() throws Throwable {
        try {
            try {
                super.finalize();
            }
            finally {
                if (this.metricAggregatorScheduledFuture != null) {
                    this.metricAggregatorScheduledFuture.cancel(true);
                }
                if (this.metricsReporterScheduledFuture != null) {
                    this.metricsReporterScheduledFuture.cancel(true);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private long timeToNextMinuteBoundary(boolean useSkew, ControllerTimeSkewSnapshot snapshot) {
        long currentTime = ClockUtils.getCurrentTime();
        currentTime = useSkew ? snapshot.adjustForSkew(currentTime) : currentTime;
        return ClockUtils.roundUpTimestampToNextMinute((long)currentTime) - currentTime;
    }

    public void rescheduleAggregatorTask(ControllerTimeSkewSnapshot snapshot) {
        this.metricAggregatorScheduledFuture.cancel(false);
        long timeToNextMinute = this.timeToNextMinuteBoundary(true, snapshot);
        long adjustedTimeToNextMinute = timeToNextMinute > 30000L ? timeToNextMinute : timeToNextMinute + 60000L;
        this.metricAggregatorScheduledFuture = this.schedulerManager.getAgentMetricReporter().scheduleAtFixedRate((IAgentRunnable)this.metricAggregator, adjustedTimeToNextMinute, (long)this.aggregationFrequencyInMillis, AgentTimeUnit.MILLISECONDS);
        this.logger.info("MetricAggregation re-scheduled at " + adjustedTimeToNextMinute + " every " + this.aggregationFrequencyInMillis);
    }

    protected IAgentScheduledFuture getMetricsReporterScheduledFuture() {
        return this.metricsReporterScheduledFuture;
    }

    protected IAgentScheduledFuture getMetricAggregatorScheduledFuture() {
        return this.metricAggregatorScheduledFuture;
    }
}

