/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration;

import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.IMetricAggregatorFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.IMetricSubscriber;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.MetricRegistrationException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.MetricSendException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.MetricsForTimeslice;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricData;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.dto.RawMetricIdentifier;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.spi.IMetricDataRequest;
import com.singularity.ee.rest.controller.request.spi.IMetricRegistrationRequest;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.collections.CollectionUtils;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentSet;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import com.singularity.ee.util.string.StringOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AMetricSubscriber
implements IMetricSubscriber {
    protected ILogger logger;
    private static final int MAX_BAD_METRIC_LOG_CHARS = 100;
    private static final int MAX_REGISTRATION_LOAD = 500;
    protected String controllerHost;
    protected int controllerPort;
    protected IEventGenerationService egs;
    protected volatile boolean blacklistLimitHit = false;
    protected ADConcurrentSet<String> blacklistedMetrics = new ADConcurrentSet();
    private boolean loggedOnce = false;

    protected AMetricSubscriber(ILogger logger, int controllerPort, String controllerHost, IEventGenerationService egs) {
        this.logger = logger;
        this.controllerPort = controllerPort;
        this.controllerHost = controllerHost;
        this.egs = egs;
    }

    protected abstract AgentType getAgentType();

    protected abstract int getMetricBlacklistLimit();

    protected abstract IMetricRegistrationRequest getMetricRegistrationRequest();

    protected abstract IMetricRegistrationRequest getMetricRegistrationResponse(IMetricRegistrationRequest var1, String var2) throws ResponseReadException;

    protected abstract void handleRegistrationRequestError(List<AgentRawMetricData> var1, IHttpExecutionResponse var2) throws MetricRegistrationException;

    protected abstract void handleRegistrationFailed(List<AgentRawMetricData> var1);

    protected abstract void onMetricRegistrationEndEvent(List<RawMetricIdentifier> var1, Map<String, String> var2, List<AgentRawMetricData> var3, Set<String> var4);

    protected abstract IMetricDataRequest getMetricDataRequest();

    protected abstract IMetricDataRequest getMetricDataResponse(IHttpExecutionResponse var1) throws ResponseReadException;

    protected abstract void handleEmptyMetricDataRequest(IMetricDataRequest var1);

    protected abstract void handleMetricSendFailureEvent(MetricsForTimeslice var1);

    protected abstract void handleMetricDataResponse(MetricsForTimeslice var1, IMetricDataRequest var2, IMetricDataRequest var3);

    protected abstract boolean isShouldMergeDuplicateMetrics();

    public List<AgentRawMetricData> registerMetrics(List<AgentRawMetricData> unregisteredMetrics, IMetricAggregatorFactory aggregatorFactory) throws MetricRegistrationException {
        if (unregisteredMetrics == null || unregisteredMetrics.isEmpty()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("No metrics to process");
            }
            return CollectionHelper.emptySerializableList();
        }
        if (!this.isInitialized()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Config channel is not initialized");
            }
            return CollectionHelper.emptySerializableList();
        }
        if (unregisteredMetrics.size() > 500) {
            List allSuccessfullyRegisteredMetrics = CollectionHelper.createLinkedList();
            List unregisteredChunk = CollectionHelper.createLinkedList();
            int chunkCount = 0;
            Iterator<AgentRawMetricData> iterator = unregisteredMetrics.iterator();
            while (iterator.hasNext()) {
                AgentRawMetricData metric = iterator.next();
                unregisteredChunk.add(metric);
                if (++chunkCount < 500 && iterator.hasNext()) continue;
                List<AgentRawMetricData> registeredChunk = this.doRegisterMetrics(unregisteredChunk, aggregatorFactory);
                allSuccessfullyRegisteredMetrics.addAll(registeredChunk);
                unregisteredChunk.clear();
                chunkCount = 0;
            }
            return allSuccessfullyRegisteredMetrics;
        }
        return this.doRegisterMetrics(unregisteredMetrics, aggregatorFactory);
    }

    private List<AgentRawMetricData> doRegisterMetrics(List<AgentRawMetricData> unregisteredMetrics, IMetricAggregatorFactory aggregatorFactory) throws MetricRegistrationException {
        List successfullyRegisteredMetrics = CollectionHelper.emptySerializableList();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering metrics with the Controller");
        }
        IMetricRegistrationRequest request = this.getMetricRegistrationRequest();
        ArrayList<RawMetricIdentifier> metricIDList = new ArrayList<RawMetricIdentifier>();
        for (AgentRawMetricData metric : unregisteredMetrics) {
            if (this.blacklistedMetrics.contains((Object)metric.getMetricIdentifier().getName())) continue;
            metricIDList.add(metric.getMetricIdentifier().toDTO());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added for metric registration " + CollectionHelper.collectionToString(metricIDList));
        }
        request.setUnregisteredMetrics(metricIDList, this.getAgentType());
        IHttpExecutionResponse httpExecutionResponse = request.sendRequest();
        if (httpExecutionResponse.isExceptionHappened() || httpExecutionResponse.isStatusNotOk() || httpExecutionResponse.isConnectionLimitActive()) {
            this.logger.warn("Problem registering metrics: " + httpExecutionResponse.getExceptionMessage());
            if (httpExecutionResponse.isConnectionLimitActive()) {
                return successfullyRegisteredMetrics;
            }
            this.handleRegistrationRequestError(unregisteredMetrics, httpExecutionResponse);
        }
        String responseBody = httpExecutionResponse.getResponseBody();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Response body for metric registration " + responseBody);
        }
        if (StringOperations.isEmpty((String)responseBody)) {
            this.logger.warn("Invalid metric registration response from Controller");
        }
        try {
            IMetricRegistrationRequest response = this.getMetricRegistrationResponse(request, responseBody);
            Map registeredMetrics = response.getRegisteredMetrics();
            if (response.getExecutionCode() != 0) {
                if (this.logger.isDebugEnabled() && !this.loggedOnce) {
                    this.loggedOnce = true;
                    this.logger.error("Metric registration error: [" + response.getExecutionOutput() + "]");
                }
                return successfullyRegisteredMetrics;
            }
            this.loggedOnce = false;
            if (registeredMetrics == null || registeredMetrics.isEmpty()) {
                ArrayList<String> unregisteredNames = new ArrayList<String>(unregisteredMetrics.size());
                for (AgentRawMetricData unregisteredMetric : unregisteredMetrics) {
                    String name = unregisteredMetric.getMetricIdentifier().getName();
                    unregisteredNames.add(name);
                    this.flagMetricAsBlacklisted(name);
                    if (aggregatorFactory == null) continue;
                    aggregatorFactory.purge(unregisteredMetric.getMetricIdentifier());
                }
                this.handleRegistrationFailed(unregisteredMetrics);
                throw new MetricRegistrationException("Invalid metric registration response from controller, empty map returned. Metrics sent for registration \n" + CollectionHelper.collectionToString(unregisteredNames) + "\nResponse Object :" + responseBody);
            }
            successfullyRegisteredMetrics = CollectionHelper.createLinkedList();
            HashSet<String> invalidMetricNameSet = new HashSet<String>();
            for (String invalidMetricName : response.getInvalidMetrics()) {
                this.flagMetricAsBlacklisted(invalidMetricName);
                invalidMetricNameSet.add(invalidMetricName);
            }
            for (AgentRawMetricData metric : unregisteredMetrics) {
                String name = metric.getMetricIdentifier().getName();
                String idString = (String)registeredMetrics.get(name);
                if (StringOperations.isEmpty((String)idString)) {
                    invalidMetricNameSet.add(name);
                    this.flagMetricAsBlacklisted(name);
                    continue;
                }
                long id = StringOperations.safeParseLong((String)idString);
                if (id < 0L) {
                    invalidMetricNameSet.add(name);
                    this.flagMetricAsBlacklisted(name);
                    continue;
                }
                metric.getMetricIdentifier().setId(id);
                successfullyRegisteredMetrics.add(metric);
            }
            if (!invalidMetricNameSet.isEmpty()) {
                this.logger.warn("Error in registering following metrics with controller ");
                CollectionUtils.logElements(invalidMetricNameSet, (ILogger)this.logger, (CollectionUtils.LogType)CollectionUtils.LogType.WARN, (int)100);
            }
            this.onMetricRegistrationEndEvent(metricIDList, registeredMetrics, unregisteredMetrics, invalidMetricNameSet);
        }
        catch (Throwable t) {
            this.logger.warn("Problem registering metrics with controller : ", t);
            throw new MetricRegistrationException("Error registering metrics with controller. Response:" + responseBody, t);
        }
        return successfullyRegisteredMetrics;
    }

    private void flagMetricAsBlacklisted(String metricName) {
        if (this.blacklistedMetrics.size() + 1 > this.getMetricBlacklistLimit()) {
            this.fireMetricBlacklistCapIfNeeded();
            this.blacklistLimitHit = true;
            return;
        }
        this.blacklistedMetrics.add((Object)metricName);
    }

    private void fireMetricBlacklistCapIfNeeded() {
        EventType type = EventType.AGENT_METRIC_BLACKLIST_REG_LIMIT_REACHED;
        if (this.egs.getInternalEventGenerator().lastEventTimedOut(type, 900000)) {
            String message = "Metric registration blacklist limit reached. Future metrics will not be registered.";
            this.logger.warn("Metric registration blacklist limit reached. Future metrics will not be registered.");
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Blacklisted metrics", StringOperations.convertToCommaSeparateString((Collection)this.blacklistedMetrics.getProperSet()));
            this.egs.getInternalEventGenerator().throwCappedInternalEvent(type, "Metric registration blacklist limit reached. Future metrics will not be registered.", details);
        }
    }

    public void publish(MetricsForTimeslice metrics) throws MetricSendException {
        IHttpExecutionResponse httpExecutionResponse;
        AgentRawMetricData[] registeredMetrics;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Sending metric data to controller on host-[" + this.controllerHost + "] controller port [" + this.controllerPort + "]");
        }
        IMetricDataRequest request = this.getMetricDataRequest();
        request.setTimestamp(metrics.getTimesliceStartTimestamp());
        if (this.isShouldMergeDuplicateMetrics()) {
            metrics.getMetrics().fixDuplicateMetrics(this.logger);
        }
        for (AgentRawMetricData metric : registeredMetrics = metrics.getMetrics().getRegisteredMetrics()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding metric to the Queue to publish [" + metric.getMetricIdentifier().getName() + "]");
            }
            request.addMetric(metric.toDTO());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Now publishing " + registeredMetrics.length + " metric data to the controller.");
        }
        if ((httpExecutionResponse = request.sendRequest()).isExceptionHappened() || httpExecutionResponse.isStatusNotOk()) {
            if (!httpExecutionResponse.isConnectionLimitActive()) {
                this.logger.warn("Error sending metric data to controller:" + httpExecutionResponse.getExceptionMessage());
            }
            this.handleMetricSendFailureEvent(metrics);
            throw new MetricSendException(httpExecutionResponse.getExceptionMessage());
        }
        this.report2MetricManager(registeredMetrics.length);
        IMetricDataRequest response = null;
        try {
            response = this.getMetricDataResponse(httpExecutionResponse);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Successfully published " + registeredMetrics.length + " metric data to the controller.");
            }
        }
        catch (ResponseReadException e) {
            this.logger.error("Error occurred in getting metric data response from the Controller", (Throwable)e);
            this.handleMetricSendFailureEvent(metrics);
            throw new MetricSendException((Throwable)e);
        }
        this.handleMetricDataResponse(metrics, request, response);
    }

    public void hotDisable() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Hot disable metric subscriber");
        }
        this.blacklistedMetrics.clear();
        this.blacklistLimitHit = false;
    }

    public void hotEnable() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Hot enable metric subscriber");
        }
    }

    public abstract boolean isInitialized();

    public void report2MetricManager(int count) {
    }
}

