/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.eventgeneration.events;

import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.util.javalang.ADLong;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.events.AgentEventData;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import java.util.Map;

public class InternalEventGenerator {
    private static final int INTERVAL_BETWEEN_SUCCESSIVE_EVENTS_MILLIS = 1800000;
    private ADConcurrentHashMap<String, ADLong> lastGeneratedEvents = new ADConcurrentHashMap();
    private IEventGenerationService eventGenerationService;

    public InternalEventGenerator(IEventGenerationService eventGenerationService) {
        this.eventGenerationService = eventGenerationService;
    }

    public boolean lastEventTimedOut(EventType type, int intervalBetweenSuccessiveEventsMs) {
        return this.lastEventTimedOut(String.valueOf(type), intervalBetweenSuccessiveEventsMs);
    }

    public boolean lastEventTimedOut(String eventTypeKey) {
        return this.lastEventTimedOut(eventTypeKey, 1800000);
    }

    private boolean lastEventTimedOut(String eventTypeKey, int intervalBetweenSuccessiveEventsMs) {
        ADLong timeStamp = (ADLong)this.lastGeneratedEvents.get((Object)eventTypeKey);
        if (timeStamp == null) {
            return true;
        }
        return ClockUtils.getCurrentTime() - timeStamp.get() > (long)intervalBetweenSuccessiveEventsMs;
    }

    public void throwCappedAgentEvent(EventType type, NotificationSeverity severity, String message, Map<String, String> details, EntityDefinition entityDefinition, String subType) {
        AgentEventData agentEventData = new AgentEventData(ClockUtils.getCurrentTime(), severity, type, details, message);
        agentEventData.setTriggeredEntity(entityDefinition);
        agentEventData.setSubType(subType);
        this.eventGenerationService.addApplicationEventIgnoreLimits(agentEventData);
        this.lastGeneratedEvents.put((Object)String.valueOf(type), (Object)new ADLong(ClockUtils.getCurrentTime()));
    }

    public void throwCappedInternalEvent(EventType type, String message) {
        this.throwCappedInternalEvent(type, message, null);
    }

    public void throwCappedInternalEvent(EventType type, String message, Map<String, String> details) {
        this.throwCappedInternalEvent(type, NotificationSeverity.ERROR, message, details);
    }

    public void throwCappedInternalEvent(EventType type, NotificationSeverity severity, String message, Map<String, String> details) {
        this.throwCappedInternalEvent(type, severity, message, details, null);
    }

    public void throwCappedInternalEvent(EventType type, NotificationSeverity severity, String message, Map<String, String> details, Map<String, Object> properties) {
        AgentEventData agentEventData = new AgentEventData(ClockUtils.getCurrentTime(), severity, type, details, message);
        agentEventData.setEventProperties(properties);
        this.eventGenerationService.addApplicationEventIgnoreLimits(agentEventData);
        this.lastGeneratedEvents.put((Object)String.valueOf(type), (Object)new ADLong(ClockUtils.getCurrentTime()));
    }

    public void throwCappedInternalEvent(EventType type, NotificationSeverity severity, String message, Map<String, String> details, Map<String, Object> properties, EntityDefinition def, String subType) {
        AgentEventData agentEventData = new AgentEventData(ClockUtils.getCurrentTime(), severity, type, details, message);
        agentEventData.setEventProperties(properties);
        agentEventData.setTriggeredEntity(def);
        agentEventData.setSubType(subType);
        this.eventGenerationService.addApplicationEventIgnoreLimits(agentEventData);
        this.lastGeneratedEvents.put((Object)String.valueOf(type), (Object)new ADLong(ClockUtils.getCurrentTime()));
    }

    public void throwCappedInternalEvent(String eventTypeKey, String message, Map<String, String> details) {
        this.eventGenerationService.addApplicationEventIgnoreLimits(new AgentEventData(ClockUtils.getCurrentTime(), NotificationSeverity.WARN, EventType.AGENT_EVENT, details, message));
        this.lastGeneratedEvents.put((Object)eventTypeKey, (Object)new ADLong(ClockUtils.getCurrentTime()));
    }

    public void throwInternalEvent(String message, Map<String, String> details) {
        this.eventGenerationService.addApplicationEvent(new AgentEventData(ClockUtils.getCurrentTime(), NotificationSeverity.WARN, EventType.AGENT_EVENT, details, message));
    }
}

