/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.eventgeneration.events;

import com.singularity.ee.agent.util.collection.AgentCollectionHelper;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.events.AgentEventData;
import com.singularity.ee.events.BTEventData;
import com.singularity.ee.events.MachineEventData;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class EventsForTimeslice
implements Serializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    private Date timesliceEndTimestamp;
    private List<AgentEventData> applicationEvents;
    private List<BTEventData> btEvents;
    private List<MachineEventData> machineEvents;

    public EventsForTimeslice(Date timesliceEndTimestamp) {
        this.timesliceEndTimestamp = timesliceEndTimestamp;
        this.applicationEvents = AgentCollectionHelper.emptyList();
        this.btEvents = AgentCollectionHelper.emptyList();
        this.machineEvents = AgentCollectionHelper.emptyList();
    }

    public Date getTimesliceEndTimestamp() {
        return this.timesliceEndTimestamp;
    }

    public List<AgentEventData> getApplicationEvents() {
        return this.applicationEvents;
    }

    public void setApplicationEvents(List<AgentEventData> applicationEvents) {
        this.applicationEvents = applicationEvents;
    }

    public List<BTEventData> getBtEvents() {
        return this.btEvents;
    }

    public void setBtEvents(List<BTEventData> btEvents) {
        this.btEvents = btEvents;
    }

    public List<MachineEventData> getMachineEvents() {
        return this.machineEvents;
    }

    public void setMachineEvents(List<MachineEventData> machineEvents) {
        this.machineEvents = machineEvents;
    }

    public boolean hasEventsToPublish() {
        return this.applicationEvents.size() > 0 || this.btEvents.size() > 0 || this.machineEvents.size() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Events in timeslice [" + this.timesliceEndTimestamp + "]").append("\n");
        for (AgentEventData agentEventData : this.applicationEvents) {
            sb.append(agentEventData.toString());
        }
        for (AgentEventData agentEventData : this.btEvents) {
            sb.append(agentEventData.toString());
        }
        for (AgentEventData agentEventData : this.machineEvents) {
            sb.append(agentEventData.toString());
        }
        return sb.toString();
    }
}

