/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.controller.metrics;

import com.singularity.ee.agent.appagent.kernel.nonboot.spi.IMetricHandler;
import com.singularity.ee.agent.commonservices.metricgeneration.MetricGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricIdentifier;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.IMetricReporter;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.IMetricReporterFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.InvalidMetricTypeException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricOverflowException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricReporterTypeMismatchException;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.controller.api.constants.MetricClusterRollupType;
import com.singularity.ee.controller.api.constants.MetricHoleHandlingType;
import com.singularity.ee.controller.api.constants.MetricTimeRollupType;

public class MetricHandler
implements IMetricHandler {
    private static IADLogger logger = ADLoggerFactory.getLogger("com.singularity.METRICS.MetricHandler");
    private final MetricGenerationService metricService;

    public MetricHandler(MetricGenerationService metricGenerationService) {
        this.metricService = metricGenerationService;
    }

    @Override
    public IMetricReporterFactory getAggregatorFactory() {
        return this.metricService.getMetricReporterFactory();
    }

    @Override
    public IMetricReporter getMetricReporter(String metricName, MetricAggregatorType aggregatorType, MetricTimeRollupType timeRollupType, MetricClusterRollupType clusterRollupType, MetricHoleHandlingType metricHoleHandlingType) throws InvalidMetricTypeException, MetricReporterTypeMismatchException, MetricOverflowException {
        AgentRawMetricIdentifier id = new AgentRawMetricIdentifier(metricName, aggregatorType, timeRollupType, clusterRollupType, metricHoleHandlingType);
        return this.metricService.getMetricReporterFactory().safeGetAggregator(id);
    }

    @Override
    public MetricGenerationService getMetricService() {
        return this.metricService;
    }

    @Override
    public void reportAverageMetric(String metricName, long metricValue) {
        MetricAggregatorType aggregator = MetricAggregatorType.AVERAGE;
        MetricTimeRollupType timeRollup = MetricTimeRollupType.AVERAGE;
        MetricClusterRollupType clusterRollup = MetricClusterRollupType.INDIVIDUAL;
        this.reportMetric(metricName, metricValue, aggregator, timeRollup, clusterRollup);
    }

    @Override
    public void reportSumMetric(String metricName, long metricValue) {
        MetricAggregatorType aggregator = MetricAggregatorType.SUM;
        MetricTimeRollupType timeRollup = MetricTimeRollupType.SUM;
        MetricClusterRollupType clusterRollup = MetricClusterRollupType.COLLECTIVE;
        this.reportMetric(metricName, metricValue, aggregator, timeRollup, clusterRollup);
    }

    @Override
    public void reportObservationMetric(String metricName, long metricValue) {
        MetricAggregatorType aggregator = MetricAggregatorType.OBSERVATION;
        MetricTimeRollupType timeRollup = MetricTimeRollupType.CURRENT;
        MetricClusterRollupType clusterRollup = MetricClusterRollupType.COLLECTIVE;
        this.reportMetric(metricName, metricValue, aggregator, timeRollup, clusterRollup);
    }

    @Override
    public void reportMetric(String metricName, long metricValue, long count, long minValue, long maxValue, MetricAggregatorType aggregatorType, MetricTimeRollupType timeRollup, MetricClusterRollupType clusterRollup) {
        try {
            IMetricReporter reporter = this.getMetricReporter(metricName, aggregatorType, timeRollup, clusterRollup);
            if (logger.isDebugEnabled()) {
                logger.debug("Reporting Metric Name [" + metricName + "] Value [" + metricValue + "]");
            }
            reporter.report(metricValue, count, minValue, maxValue);
        }
        catch (MetricReporterTypeMismatchException e) {
            logger.warn("Metric Reporter type mismatch for metric [" + metricName + "]", e);
        }
        catch (MetricOverflowException e) {
            logger.warn("Metric Size exceeded, could not create reporter for [" + metricName + "]", e);
        }
    }

    @Override
    public void reportMetric(String metricName, long metricValue, MetricAggregatorType aggregatorType, MetricTimeRollupType timeRollup, MetricClusterRollupType clusterRollup) {
        try {
            IMetricReporter reporter = this.getMetricReporter(metricName, aggregatorType, timeRollup, clusterRollup);
            if (logger.isDebugEnabled()) {
                logger.debug("Reporting Metric Name [" + metricName + "] Value [" + metricValue + "]");
            }
            reporter.report(metricValue);
        }
        catch (MetricReporterTypeMismatchException e) {
            logger.warn("Metric Reporter type mismatch for metric [" + metricName + "]", e);
        }
        catch (MetricOverflowException e) {
            logger.warn("Metric Size exceeded, could not create reporter for [" + metricName + "]", e);
        }
    }

    private IMetricReporter getMetricReporter(String metricName, MetricAggregatorType aggregatorType, MetricTimeRollupType timeRollup, MetricClusterRollupType clusterRollup) throws MetricOverflowException, MetricReporterTypeMismatchException {
        AgentRawMetricIdentifier id = new AgentRawMetricIdentifier(metricName, aggregatorType, timeRollup, clusterRollup, MetricHoleHandlingType.REGULAR_COUNTER);
        IMetricAggregator reporter = this.getAggregatorFactory().safeGetAggregator(id);
        return reporter;
    }

    public void hotDisable() {
        this.metricService.hotDisable();
    }

    public void hotEnable() {
        this.metricService.hotEnable();
    }
}

