/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.utils;

import com.appdynamics.voltron.rest.utils.AppdMediaTypes;
import com.appdynamics.voltron.utils.ExceptionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class RestException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    @VisibleForTesting
    static final String STACKTRACE_HIDDEN_MESSAGE = "Hidden";
    public static final String STACKTRACE_STRING = "* Server stack trace:";
    public static final boolean OMIT_SERVER_STACKTRACE_LOGGING_DEFAULT = false;
    private Payload payload;

    protected RestException() {
        this.payload = new Payload();
    }

    public RestException(int httpStatus, String code, String userMessage, boolean includeStacktrace) {
        this(httpStatus, code, userMessage, null, null, includeStacktrace);
    }

    public RestException(int httpStatus, String code, String userMessage, Throwable cause, boolean includeStacktrace) {
        this(httpStatus, code, userMessage, null, cause, includeStacktrace);
    }

    public RestException(int httpStatus, String code, String userMessage, String addlInfo, boolean includeStacktrace) {
        this(httpStatus, code, userMessage, addlInfo, null, includeStacktrace);
    }

    public RestException(int httpStatus, String code, String userMessage, String additionalInfo, Throwable cause, boolean shouldShowStackTrace) {
        super(cause);
        Preconditions.checkNotNull((Object)code, (Object)"code is null");
        Preconditions.checkNotNull((Object)userMessage, (Object)"userMessage is null");
        this.payload = new Payload();
        this.payload.setHttpStatus(httpStatus).setCode(code).setUserMessage(userMessage).setAdditionalInfo(additionalInfo).safeSetServerStackTrace(this, shouldShowStackTrace);
    }

    @Override
    public String getMessage() {
        return this.getMessage(false);
    }

    public String getMessage(boolean omitStackTrace) {
        StringBuilder sb = new StringBuilder().append(this.getUserMessage()).append(" (").append(this.getHttpStatus()).append(" - ").append(this.getCode()).append(")");
        if (this.getAdditionalInfo() != null && !this.getAdditionalInfo().isEmpty()) {
            sb.append("\n\t* Additional Info:").append(this.getAdditionalInfo());
        }
        if (!omitStackTrace && this.getServerStackTrace() != null) {
            sb.append("\n\t");
            sb.append(STACKTRACE_STRING);
            sb.append("\n\t\t");
            sb.append(this.getServerStackTrace().replaceAll("\\n", "\n\t\t"));
        }
        return sb.toString();
    }

    public Response getResponse() {
        return Response.status((int)this.getHttpStatus()).type(RestException.mediaType()).entity((Object)this.payload).build();
    }

    public static MediaType mediaType() {
        return MediaType.valueOf((String)AppdMediaTypes.appdJsonType("exception"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestException)) {
            return false;
        }
        RestException other = (RestException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Payload this$payload = this.payload;
        Payload other$payload = other.payload;
        return !(this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Payload $payload = this.payload;
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        return result;
    }

    public int getHttpStatus() {
        return this.payload.getHttpStatus();
    }

    public String getCode() {
        return this.payload.getCode();
    }

    public String getUserMessage() {
        return this.payload.getUserMessage();
    }

    public String getAdditionalInfo() {
        return this.payload.getAdditionalInfo();
    }

    public String getServerStackTrace() {
        return this.payload.getServerStackTrace();
    }

    public Payload setHttpStatus(int httpStatus) {
        return this.payload.setHttpStatus(httpStatus);
    }

    public Payload setCode(String code) {
        return this.payload.setCode(code);
    }

    public Payload setUserMessage(String userMessage) {
        return this.payload.setUserMessage(userMessage);
    }

    public Payload setAdditionalInfo(String additionalInfo) {
        return this.payload.setAdditionalInfo(additionalInfo);
    }

    public Payload setServerStackTrace(String serverStackTrace) {
        return this.payload.setServerStackTrace(serverStackTrace);
    }

    private static class Payload {
        private int httpStatus;
        private String code;
        private String userMessage;
        private String additionalInfo;
        private String serverStackTrace;

        private Payload safeSetServerStackTrace(Exception exception, boolean shouldShow) {
            this.serverStackTrace = shouldShow ? ExceptionUtils.toString((Throwable)exception) : RestException.STACKTRACE_HIDDEN_MESSAGE;
            return this;
        }

        public int getHttpStatus() {
            return this.httpStatus;
        }

        public String getCode() {
            return this.code;
        }

        public String getUserMessage() {
            return this.userMessage;
        }

        public String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        public Payload setHttpStatus(int httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public Payload setCode(String code) {
            this.code = code;
            return this;
        }

        public Payload setUserMessage(String userMessage) {
            this.userMessage = userMessage;
            return this;
        }

        public Payload setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public Payload setServerStackTrace(String serverStackTrace) {
            this.serverStackTrace = serverStackTrace;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Payload)) {
                return false;
            }
            Payload other = (Payload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHttpStatus() != other.getHttpStatus()) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$userMessage = this.getUserMessage();
            String other$userMessage = other.getUserMessage();
            if (this$userMessage == null ? other$userMessage != null : !this$userMessage.equals(other$userMessage)) {
                return false;
            }
            String this$additionalInfo = this.getAdditionalInfo();
            String other$additionalInfo = other.getAdditionalInfo();
            if (this$additionalInfo == null ? other$additionalInfo != null : !this$additionalInfo.equals(other$additionalInfo)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Payload;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHttpStatus();
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $userMessage = this.getUserMessage();
            result = result * 59 + ($userMessage == null ? 43 : $userMessage.hashCode());
            String $additionalInfo = this.getAdditionalInfo();
            result = result * 59 + ($additionalInfo == null ? 43 : $additionalInfo.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }

        public String toString() {
            return "RestException.Payload(httpStatus=" + this.getHttpStatus() + ", code=" + this.getCode() + ", userMessage=" + this.getUserMessage() + ", additionalInfo=" + this.getAdditionalInfo() + ", serverStackTrace=" + this.getServerStackTrace() + ")";
        }
    }
}

