/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.ssl;

import com.google.common.base.Optional;
import com.google.inject.ProvisionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreLoader {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreLoader.class);
    private final Optional<String> keyStorePath;
    private final Optional<String> keyStorePasswordOptional;

    KeyStoreLoader(@NonNull Optional<String> keyStorePath, @NonNull Optional<String> keyStorePassword) {
        if (keyStorePath == null) {
            throw new NullPointerException("keyStorePath is marked non-null but is null");
        }
        if (keyStorePassword == null) {
            throw new NullPointerException("keyStorePassword is marked non-null but is null");
        }
        this.keyStorePath = keyStorePath;
        this.keyStorePasswordOptional = keyStorePassword;
    }

    public Optional<KeyStore> read() {
        if (this.keyStorePath.isPresent()) {
            try {
                File keystoreFile = new File((String)this.keyStorePath.get());
                FileInputStream fis = new FileInputStream(keystoreFile);
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                char[] keyStorePasswordCharArray = null;
                if (this.keyStorePasswordOptional.isPresent()) {
                    keyStorePasswordCharArray = ((String)this.keyStorePasswordOptional.get()).toCharArray();
                }
                keystore.load(fis, keyStorePasswordCharArray);
                if (log.isDebugEnabled()) {
                    log.debug("Keystore file {} was successfully read.", this.keyStorePath.get());
                }
                return Optional.of((Object)keystore);
            }
            catch (FileNotFoundException e) {
                log.error("Keystore file {} was not found.", this.keyStorePath.get(), (Object)e);
                throw new ProvisionException("Failed to find specified KeyStore file " + (String)this.keyStorePath.get(), (Throwable)e);
            }
            catch (Throwable t) {
                log.error("Failed to read keystore file " + (String)this.keyStorePath.get(), t);
                throw new ProvisionException("Failed to read specified KeyStore file " + (String)this.keyStorePath.get(), t);
            }
        }
        return Optional.absent();
    }
}

