/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.ssl;

import com.appdynamics.voltron.rest.client.ssl.FeignTrustStore;
import com.appdynamics.voltron.rest.client.ssl.FullChainValidation;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlexibleX509TrustManager
implements X509TrustManager {
    private static final Logger log = LoggerFactory.getLogger(FlexibleX509TrustManager.class);
    private final boolean enforceFullValidation;
    @VisibleForTesting
    private final X509TrustManager delegate;

    @Inject
    FlexibleX509TrustManager(@FullChainValidation @NonNull Boolean enforceFullValidation, @FeignTrustStore @NonNull Optional<KeyStore> keyStore) {
        if (enforceFullValidation == null) {
            throw new NullPointerException("enforceFullValidation is marked non-null but is null");
        }
        if (keyStore == null) {
            throw new NullPointerException("keyStore is marked non-null but is null");
        }
        if (enforceFullValidation.booleanValue()) {
            log.info("Enforcing full SSL validation.");
        }
        if (keyStore.isPresent()) {
            log.info("Using custom keystore for SSL certificate validation.");
        } else {
            log.info("Using default keystore for SSL certificate validation.");
        }
        this.enforceFullValidation = enforceFullValidation;
        this.delegate = this.getTrustManager(keyStore);
        if (log.isTraceEnabled()) {
            log.trace("Accepted issuers:");
            for (X509Certificate cert : this.getAcceptedIssuers()) {
                log.trace("    {}", (Object)cert.getIssuerX500Principal().getName());
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        log.debug("X509Certificates: {}", (Object[])certificates);
        try {
            if (certificates == null || certificates.length == 0) {
                throw new IllegalArgumentException("Provided certificate chain was null or zero-length.");
            }
            if (this.enforceFullValidation) {
                this.delegate.checkServerTrusted(certificates, authType);
            } else {
                for (X509Certificate certificate : certificates) {
                    certificate.checkValidity();
                }
            }
        }
        catch (CertificateException e) {
            log.warn("Certificate chain validation failed: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }

    private X509TrustManager getTrustManager(Optional<KeyStore> keyStore) {
        TrustManagerFactory factory;
        try {
            factory = TrustManagerFactory.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProvisionException("Could not instantiate trust manager", (Throwable)e);
        }
        try {
            factory.init((KeyStore)keyStore.orNull());
        }
        catch (KeyStoreException e) {
            throw new ProvisionException("Could not read the key store.", (Throwable)e);
        }
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new ProvisionException("No trust managers found");
        }
        return (X509TrustManager)trustmanagers[0];
    }

    X509TrustManager getDelegate() {
        return this.delegate;
    }
}

