/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.ssl;

import com.appdynamics.voltron.rest.client.ssl.ClientAuthentication;
import com.appdynamics.voltron.rest.client.ssl.FeignKeyStore;
import com.appdynamics.voltron.rest.client.ssl.KeyStorePrivateKeyPassword;
import com.appdynamics.voltron.utils.annotations.Nullable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import lombok.NonNull;

class FlexibleX509KeyManagerProvider
implements Provider<X509KeyManager> {
    private final boolean clientAuthenticationEnabled;
    private final KeyManagerFactory keyManagerFactory;
    private final Optional<KeyStore> keyStore;
    private final Optional<String> privateKeyPassword;

    @Inject
    FlexibleX509KeyManagerProvider(@ClientAuthentication @NonNull Boolean clientAuthenticationEnabled, @FeignKeyStore KeyManagerFactory keyManagerFactory, @FeignKeyStore @NonNull Optional<KeyStore> keyStore, @KeyStorePrivateKeyPassword @NonNull Optional<String> privateKeyPassword) {
        if (clientAuthenticationEnabled == null) {
            throw new NullPointerException("clientAuthenticationEnabled is marked non-null but is null");
        }
        if (keyStore == null) {
            throw new NullPointerException("keyStore is marked non-null but is null");
        }
        if (privateKeyPassword == null) {
            throw new NullPointerException("privateKeyPassword is marked non-null but is null");
        }
        this.clientAuthenticationEnabled = clientAuthenticationEnabled;
        this.keyManagerFactory = keyManagerFactory;
        this.keyStore = keyStore;
        this.privateKeyPassword = privateKeyPassword;
    }

    public X509KeyManager get() {
        try {
            Optional<KeyStore> factoryKeyStore = Optional.absent();
            if (Boolean.TRUE.equals(this.clientAuthenticationEnabled)) {
                factoryKeyStore = this.keyStore;
            }
            char[] privateKeyPasswordCharArr = null;
            if (factoryKeyStore.isPresent() && this.privateKeyPassword.isPresent()) {
                privateKeyPasswordCharArr = ((String)this.privateKeyPassword.get()).toCharArray();
            }
            this.initKeyManagerFactory((KeyStore)factoryKeyStore.orNull(), privateKeyPasswordCharArr);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new ProvisionException("Could not read the key store.", (Throwable)e);
        }
        KeyManager[] keyManagers = this.getKeyManagers();
        if (keyManagers.length == 0) {
            throw new ProvisionException("No key managers found");
        }
        return (X509KeyManager)keyManagers[0];
    }

    @VisibleForTesting
    void initKeyManagerFactory(@Nullable KeyStore keystore, char[] privateKeyPasswordCharArr) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        this.keyManagerFactory.init(keystore, privateKeyPasswordCharArr);
    }

    @VisibleForTesting
    KeyManager[] getKeyManagers() {
        return this.keyManagerFactory.getKeyManagers();
    }
}

