/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.ssl;

import com.appdynamics.voltron.rest.client.VoltronFeign;
import com.appdynamics.voltron.rest.client.ssl.ClientKeyAlias;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.X509KeyManager;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlexibleX509KeyManager
implements X509KeyManager {
    private static final Logger log = LoggerFactory.getLogger(FlexibleX509KeyManager.class);
    private final X509KeyManager delegate;
    private final Optional<String> keyAliasOpt;

    @Inject
    FlexibleX509KeyManager(@VoltronFeign X509KeyManager delegate, @ClientKeyAlias @NonNull Optional<String> keyAliasOpt) {
        if (keyAliasOpt == null) {
            throw new NullPointerException("keyAliasOpt is marked non-null but is null");
        }
        this.keyAliasOpt = keyAliasOpt;
        this.delegate = delegate;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] principals) {
        return this.delegate.getClientAliases(keyType, principals);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] principals, Socket socket) {
        if (!this.keyAliasOpt.isPresent()) {
            String chosenAlias = this.delegate.chooseClientAlias(keyTypes, principals, socket);
            log.debug("Client Authentication - KeyStore alias chosen is: {}", (Object)chosenAlias);
            return chosenAlias;
        }
        if (keyTypes == null || keyTypes.length == 0) {
            log.warn("Failing attempt to choose client key alias without any given keyTypes");
            return null;
        }
        String keyAlias = (String)this.keyAliasOpt.get();
        for (String keyType : keyTypes) {
            Object[] keyAliases = this.getClientAliases(keyType, principals);
            if (keyAliases == null) {
                log.debug("Attempt to search client key Aliases of keyType: " + keyType + " returned nothing.");
                continue;
            }
            log.debug("Attempt to search client key Aliases of keyType: {} returned: {}", (Object)keyType, (Object)Arrays.toString(keyAliases));
            for (Object candidateKeyAlias : keyAliases) {
                if (!this.matchAlias(keyAlias, (String)candidateKeyAlias)) continue;
                log.info("Matched and selected Key alias: {}", candidateKeyAlias);
                return candidateKeyAlias;
            }
        }
        log.info("Could not find matching Client Key with alias: {}", this.keyAliasOpt);
        return null;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] principals) {
        return this.delegate.getServerAliases(keyType, principals);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] principals, Socket socket) {
        return this.delegate.chooseServerAlias(keyType, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.delegate.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegate.getPrivateKey(alias);
    }

    private boolean matchAlias(String keyAlias, String candidateKeyAlias) {
        if (candidateKeyAlias == null || candidateKeyAlias.length() < keyAlias.length()) {
            return false;
        }
        if (candidateKeyAlias.length() == keyAlias.length()) {
            return candidateKeyAlias.equals(keyAlias);
        }
        return candidateKeyAlias.endsWith("." + keyAlias);
    }
}

