/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.impl.apache;

import com.appdynamics.voltron.rest.client.impl.apache.ApacheFeignClient;
import com.appdynamics.voltron.rest.client.impl.apache.ConnectionCleanerConfig;
import com.google.inject.Inject;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.http.conn.HttpClientConnectionManager;

final class ConnectionCleanerTask
implements Runnable {
    private final Object $lock = new Object[0];
    private final ConnectionCleanerConfig cleanerConfig;
    private final ScheduledExecutorService executorService;
    private final HttpClientConnectionManager connectionManager;
    private ScheduledFuture<?> future;

    @Inject
    ConnectionCleanerTask(@ApacheFeignClient ConnectionCleanerConfig cleanerConfig, @ApacheFeignClient ScheduledExecutorService executorService, @ApacheFeignClient HttpClientConnectionManager connectionManager) {
        this.cleanerConfig = cleanerConfig;
        this.executorService = executorService;
        this.connectionManager = connectionManager;
        this.scheduleTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTask() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future == null) {
                this.future = this.executorService.scheduleWithFixedDelay(this, this.cleanerConfig.getCleaningIntervalMillis(), this.cleanerConfig.getCleaningIntervalMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void unscheduleTask() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    @Override
    public void run() {
        this.connectionManager.closeIdleConnections(this.cleanerConfig.getConnectionIdleTimeoutMillis(), TimeUnit.MILLISECONDS);
    }
}

