/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.impl.apache;

import com.appdynamics.voltron.rest.client.VoltronFeignGzip;
import com.appdynamics.voltron.rest.client.impl.apache.ApacheFeignClient;
import com.appdynamics.voltron.rest.client.impl.log.SimRegistrationRepetitiveLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Inject;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheClientImpl
implements Client {
    private static final Logger log = LoggerFactory.getLogger(ApacheClientImpl.class);
    private final AuthCache authCache;
    private final HttpClient httpClient;
    private final boolean gzipEnabled;
    private final SimRegistrationRepetitiveLogger repetitiveLogger;
    private final String REGISTRATION_REQUEST_ENDPOINT = "/controller/sim/v2/agent/machines";

    @Inject
    private ApacheClientImpl(@ApacheFeignClient AuthCache authCache, @ApacheFeignClient HttpClient httpClient, @VoltronFeignGzip boolean gzipEnabled, SimRegistrationRepetitiveLogger repetitiveLogger) {
        this.authCache = authCache;
        this.httpClient = httpClient;
        this.gzipEnabled = gzipEnabled;
        this.repetitiveLogger = repetitiveLogger;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        HttpUriRequest apacheRequest = this.buildRequest(request);
        this.addBody(apacheRequest, request);
        this.addHeaders(apacheRequest, request);
        HttpClientContext httpContext = new HttpClientContext();
        httpContext.setAuthCache(this.authCache);
        if (request.url() != null && request.url().endsWith("/controller/sim/v2/agent/machines")) {
            String requestLine = apacheRequest.getRequestLine().toString();
            this.repetitiveLogger.info(log, "Sending registration request: {}", requestLine);
        }
        log.debug("Printing request: {}", (Object)apacheRequest.getRequestLine());
        return (Response)this.httpClient.execute(apacheRequest, (ResponseHandler)new FeignResponseHandler(request, this.repetitiveLogger), (HttpContext)httpContext);
    }

    private HttpUriRequest buildRequest(Request request) {
        String uri = request.url();
        switch (request.httpMethod()) {
            case POST: {
                return new HttpPost(uri);
            }
            case GET: {
                return new HttpGet(uri);
            }
            case PUT: {
                return new HttpPut(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case PATCH: {
                return new HttpPatch(uri);
            }
        }
        throw new IllegalArgumentException("HTTP method " + String.valueOf(request.httpMethod()) + " is not supported.");
    }

    private void addBody(HttpUriRequest apacheRequest, Request request) {
        if (request.body() != null && request.body().length > 0) {
            byte[] body = request.body();
            ByteArrayEntity entity = new ByteArrayEntity(body);
            if (this.gzipEnabled) {
                entity = new GzipCompressingEntity((HttpEntity)entity);
            }
            if (apacheRequest instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest apacheEntityRequest = (HttpEntityEnclosingRequest)apacheRequest;
                apacheEntityRequest.setEntity((HttpEntity)entity);
            } else {
                log.warn("Method {} does not allow entity, but request body was given. Ignoring.", (Object)apacheRequest.getMethod());
            }
        }
    }

    private void addHeaders(HttpUriRequest apacheRequest, Request request) {
        for (Map.Entry headerEntry : request.headers().entrySet()) {
            for (String val : (Collection)headerEntry.getValue()) {
                if (((String)headerEntry.getKey()).equalsIgnoreCase("Content-Length")) continue;
                apacheRequest.addHeader((String)headerEntry.getKey(), val);
            }
        }
    }

    @VisibleForTesting
    static class FeignResponseHandler
    implements ResponseHandler<Response> {
        private final Request request;
        private final SimRegistrationRepetitiveLogger repetitiveLogger;
        private final String REGISTRATION_REQUEST_ENDPOINT = "/controller/sim/v2/agent/machines";

        private FeignResponseHandler(Request request, SimRegistrationRepetitiveLogger repetitiveLogger) {
            this.request = request;
            this.repetitiveLogger = repetitiveLogger;
            log.debug("Request that is sent: {}", (Object)request);
        }

        public Response handleResponse(HttpResponse response) throws IOException, ClientProtocolException {
            byte[] data = null;
            log.debug("Printing the request: {}", (Object)this.request.url());
            HttpEntity entity = response.getEntity();
            if (this.request.url() != null && this.request.url().endsWith("/controller/sim/v2/agent/machines")) {
                String requestUrl = this.request.url();
                String statusLine = response.getStatusLine().toString();
                this.repetitiveLogger.info(log, "Handling registration response for endpoint: {}", requestUrl);
                this.repetitiveLogger.info(log, "Received registration response; status: {}", statusLine);
            }
            if (entity != null) {
                ByteArrayOutputStream baos;
                log.debug("Printing content length of entity: {}", (Object)entity.getContentLength());
                if (entity.getContentLength() > 0L) {
                    long contentLength = entity.getContentLength();
                    if (contentLength > Integer.MAX_VALUE) {
                        log.debug("Cannot handle content larger than: 2147483647 bytes.");
                        throw new IOException("Cannot handle content larger than 2147483647 bytes.");
                    }
                    baos = new ByteArrayOutputStream((int)contentLength);
                } else {
                    baos = new ByteArrayOutputStream();
                }
                entity.writeTo((OutputStream)baos);
                data = baos.toByteArray();
            }
            log.debug("Got response: {}", (Object)response);
            log.debug("Printing response statusCode: {}", (Object)response.getStatusLine().getStatusCode());
            log.debug("Printing response reasonPhrase: {}", (Object)response.getStatusLine().getReasonPhrase());
            return Response.builder().request(this.request).status(response.getStatusLine().getStatusCode()).reason(response.getStatusLine().getReasonPhrase()).headers(this.buildHeaders(response.getAllHeaders())).body(data).build();
        }

        private Map<String, Collection<String>> buildHeaders(Header[] allHeaders) {
            ArrayListMultimap headers = ArrayListMultimap.create((int)allHeaders.length, (int)1);
            for (Header header : allHeaders) {
                headers.put((Object)header.getName(), (Object)header.getValue());
            }
            return headers.asMap();
        }
    }
}

