/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client;

import com.appdynamics.voltron.rest.client.NonRestException;
import com.appdynamics.voltron.rest.utils.RestException;
import feign.RetryableException;
import feign.Retryer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoltronRetryer
implements Retryer {
    private static final Logger log = LoggerFactory.getLogger(VoltronRetryer.class);
    private final Retryer innerRetryer;

    public static VoltronRetryer createWithDefaultRetryer(long period, long maxPeriod, int maxAttempts) {
        return new VoltronRetryer((Retryer)new Retryer.Default(period, maxPeriod, maxAttempts));
    }

    public static VoltronRetryer createWithRetryer(Retryer innerRetryer) {
        return new VoltronRetryer(innerRetryer);
    }

    private VoltronRetryer(Retryer retryer) {
        this.innerRetryer = retryer;
    }

    public void continueOrPropagate(RetryableException e) {
        try {
            this.innerRetryer.continueOrPropagate(e);
        }
        catch (RetryableException ex) {
            if (ex.getCause() instanceof RestException || ex.getCause() instanceof NonRestException) {
                log.error("RetryableException caught during retry process:", (Throwable)ex);
                throw (RuntimeException)ex.getCause();
            }
            log.error("RetryableException with RestException or NonRestException cause:", (Throwable)e);
            throw e;
        }
    }

    public Retryer clone() {
        return new VoltronRetryer(this.innerRetryer.clone());
    }
}

