/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client;

import com.appdynamics.voltron.rest.client.FeignResponseException;
import com.appdynamics.voltron.rest.client.NonRestException;
import com.appdynamics.voltron.rest.client.VoltronFeign;
import com.appdynamics.voltron.rest.utils.RestException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import feign.Response;
import feign.RetryableException;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VoltronErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(VoltronErrorDecoder.class);
    private final ObjectMapper mapper;

    @Inject
    VoltronErrorDecoder(@VoltronFeign ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Exception decode(String methodKey, Response response) {
        String contentType;
        RuntimeException exception = null;
        Collection contentTypes = (Collection)response.headers().get("Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty() && MediaType.valueOf((String)(contentType = (String)contentTypes.iterator().next())).isCompatible(RestException.mediaType())) {
            String errorText = null;
            if (response.body() != null) {
                try (InputStream input = response.body().asInputStream();){
                    errorText = CharStreams.toString((Readable)new InputStreamReader(input, Charsets.UTF_8));
                    exception = (RuntimeException)this.mapper.readValue(errorText, RestException.class);
                }
                catch (IOException e) {
                    if (errorText == null) {
                        log.warn("Could not read exception payload", (Throwable)e);
                    }
                    log.warn("Could not parse exception payload " + errorText, (Throwable)e);
                }
            }
        }
        if (exception == null) {
            exception = new NonRestException(methodKey, response);
        }
        if (!this.isRetryableException(response)) {
            if (exception instanceof NonRestException) {
                return exception;
            }
            return new FeignResponseException(methodKey, exception, response);
        }
        return new RetryableException(response.status(), "Request " + methodKey + " " + response.status() + " " + response.reason(), response.request().httpMethod(), (Throwable)exception, null, response.request());
    }

    private boolean isRetryableException(Response response) {
        return response.status() == Response.Status.SERVICE_UNAVAILABLE.getStatusCode();
    }
}

