/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client;

import com.appdynamics.voltron.rest.client.FeignServiceFactory;
import com.appdynamics.voltron.rest.client.RestClientPath;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Provider;

class RestClientProvider<T>
implements Provider<T> {
    private final Class<T> targetClass;
    private volatile FeignServiceFactory serviceFactory;
    private volatile Provider<String> path;

    RestClientProvider(Class<T> targetClass) {
        this.targetClass = targetClass;
    }

    public T get() {
        return this.serviceFactory.makeServiceProxyFor(this.targetClass, (String)this.path.get());
    }

    @Inject
    @VisibleForTesting
    void setServiceFactory(FeignServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    @Inject
    @VisibleForTesting
    void setPath(@RestClientPath Provider<String> path) {
        this.path = path;
    }
}

