/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client;

import com.google.common.base.Optional;
import lombok.NonNull;

public class ProxyConfig {
    @NonNull
    private final String hostname;
    private final int port;
    @NonNull
    private final Optional<Auth> auth;

    public ProxyConfig(@NonNull String hostname, int port, @NonNull Optional<Auth> auth) {
        if (hostname == null) {
            throw new NullPointerException("hostname is marked non-null but is null");
        }
        if (auth == null) {
            throw new NullPointerException("auth is marked non-null but is null");
        }
        this.hostname = hostname;
        this.port = port;
        this.auth = auth;
    }

    @NonNull
    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    @NonNull
    public Optional<Auth> getAuth() {
        return this.auth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyConfig)) {
            return false;
        }
        ProxyConfig other = (ProxyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        Optional<Auth> this$auth = this.getAuth();
        Optional<Auth> other$auth = other.getAuth();
        return !(this$auth == null ? other$auth != null : !this$auth.equals(other$auth));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProxyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        Optional<Auth> $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        return result;
    }

    public String toString() {
        return "ProxyConfig(hostname=" + this.getHostname() + ", port=" + this.getPort() + ", auth=" + String.valueOf(this.getAuth()) + ")";
    }

    public static class Auth {
        @NonNull
        private final String username;
        @NonNull
        private final String password;
        private final boolean preemptiveAuth;

        public Auth(@NonNull String username, @NonNull String password, boolean preemptiveAuth) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            if (password == null) {
                throw new NullPointerException("password is marked non-null but is null");
            }
            this.username = username;
            this.password = password;
            this.preemptiveAuth = preemptiveAuth;
        }

        @NonNull
        public String getUsername() {
            return this.username;
        }

        @NonNull
        public String getPassword() {
            return this.password;
        }

        public boolean isPreemptiveAuth() {
            return this.preemptiveAuth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Auth)) {
                return false;
            }
            Auth other = (Auth)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPreemptiveAuth() != other.isPreemptiveAuth()) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Auth;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPreemptiveAuth() ? 79 : 97);
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "ProxyConfig.Auth(username=" + this.getUsername() + ", password=" + this.getPassword() + ", preemptiveAuth=" + this.isPreemptiveAuth() + ")";
        }
    }
}

