/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client;

import feign.Response;

public class NonRestException
extends RuntimeException {
    private final String methodKey;
    private final Response response;

    public NonRestException(String methodKey, Response response) {
        super(NonRestException.buildMessage(methodKey, response));
        this.methodKey = methodKey;
        this.response = response;
    }

    private static String buildMessage(String methodKey, Response response) {
        StringBuilder builder = new StringBuilder();
        builder.append("Method: ").append(methodKey).append(" - Result: ").append(response.status()).append(" ").append(response.reason());
        if (response.body() != null) {
            builder.append(" - content:\n").append(response.body());
        }
        return builder.toString();
    }

    public String getMethodKey() {
        return this.methodKey;
    }

    public Response getResponse() {
        return this.response;
    }
}

