/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client;

import feign.Response;

public class FeignResponseException
extends RuntimeException {
    private final Response response;
    private final String methodKey;
    private final Throwable cause;

    public FeignResponseException(String methodKey, Throwable cause, Response response) {
        super(FeignResponseException.buildMessage(methodKey, response), cause);
        this.response = response;
        this.methodKey = methodKey;
        this.cause = cause;
    }

    private static String buildMessage(String methodKey, Response response) {
        StringBuilder builder = new StringBuilder();
        builder.append("method: ").append(methodKey).append(" - result: ").append(response.status()).append(" ").append(response.reason());
        if (response.body() != null) {
            builder.append(" - content:\n").append(response.body());
        }
        return builder.toString();
    }

    public Response getResponse() {
        return this.response;
    }

    public String getMethodKey() {
        return this.methodKey;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }
}

