/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.common.interning;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public final class InternedObjectsStore {
    private static final String DEFAULT_MAX_LONG_OR_INT_POOL_SIZE = "2000000";
    private static final int MAXIMUM_SIZE_LONG_OR_INT_POOL = Integer.parseInt(System.getProperty(InternedObjectsStore.class.getName() + ".longorintsize", "2000000"));
    private static final String DEFAULT_MAX_STRINGPOOL_SIZE = "2000000";
    private static final int MAXIMUM_SIZE_STRINGPOOL = Integer.parseInt(System.getProperty(InternedObjectsStore.class.getName() + ".stringsize", "2000000"));
    private static final int MAXIMUM_STRING_LENGTH = 256;
    private static LoadingCache<String, String> stringPool;
    private static LoadingCache<Long, Long> longPool;
    private static LoadingCache<Integer, Integer> integerPool;

    private InternedObjectsStore() {
    }

    public static void rebuildStringPool(int maxSize, int readTTLInDays) {
        stringPool = CacheBuilder.newBuilder().maximumSize((long)maxSize).initialCapacity(1000).concurrencyLevel(8).expireAfterAccess((long)readTTLInDays, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) {
                return key;
            }
        });
    }

    public static void rebuildLongPool(int maxSize, int readTTLInDays) {
        longPool = CacheBuilder.newBuilder().maximumSize((long)maxSize).initialCapacity(1000).concurrencyLevel(8).expireAfterAccess((long)readTTLInDays, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<Long, Long>(){

            public Long load(Long key) {
                return key;
            }
        });
    }

    public static void rebuildIntegerPool(int maxSize, int readTTLInDays) {
        integerPool = CacheBuilder.newBuilder().maximumSize((long)maxSize).expireAfterAccess((long)readTTLInDays, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<Integer, Integer>(){

            public Integer load(Integer key) {
                return key;
            }
        });
    }

    public static void unintern(Set<String> values) {
        stringPool.invalidateAll(values);
    }

    public static String maybeIntern(String val) {
        if (val == null) {
            return null;
        }
        if (val.isEmpty()) {
            return "";
        }
        String ret = (String)stringPool.getIfPresent((Object)val);
        if (ret == null) {
            ret = val;
        }
        return ret;
    }

    public static void internPublicStaticStrings(@NotNull Class<?> c) {
        Field[] fields;
        for (Field field : fields = c.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !field.getType().equals(String.class)) continue;
            try {
                String val = (String)field.get(null);
                stringPool.put((Object)val, (Object)val);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static Long intern(@NotNull Long val) {
        long longVal = val;
        if (longVal >= -128L && longVal <= 127L) {
            return longVal;
        }
        return (Long)longPool.getUnchecked((Object)val);
    }

    public static Integer intern(@NotNull Integer val) {
        int intVal = val;
        if (intVal >= -128 && intVal <= 127) {
            return intVal;
        }
        return (Integer)integerPool.getUnchecked((Object)val);
    }

    public static String intern(String val) {
        if (val == null || val.length() > 256) {
            return val;
        }
        if (val.isEmpty()) {
            return "";
        }
        return (String)stringPool.getUnchecked((Object)val);
    }

    public static Object maybeInternObject(@NotNull Object value) {
        if (value instanceof Long) {
            return InternedObjectsStore.intern((Long)value);
        }
        if (value instanceof String) {
            return InternedObjectsStore.intern((String)value);
        }
        if (value instanceof Integer) {
            return InternedObjectsStore.intern((Integer)value);
        }
        return value;
    }

    static {
        InternedObjectsStore.rebuildStringPool(MAXIMUM_SIZE_STRINGPOOL, 7);
        InternedObjectsStore.rebuildLongPool(MAXIMUM_SIZE_LONG_OR_INT_POOL, 7);
        InternedObjectsStore.rebuildIntegerPool(MAXIMUM_SIZE_LONG_OR_INT_POOL, 1);
    }
}

