/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache;

import com.appdynamics.platform.services.common.interning.InternedObjectsStore;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public class ReferenceCountMap<K>
implements Serializable {
    private final ConcurrentHashMap<K, Integer> map = new ConcurrentHashMap();

    public Integer addDeltaIfPresent(K key, final int valueToBeAdded) {
        return this.map.compute(key, new BiFunction<K, Integer, Integer>(){

            @Override
            public Integer apply(K key, Integer origVal) {
                if (origVal != null) {
                    return InternedObjectsStore.intern((Integer)(origVal + valueToBeAdded));
                }
                return null;
            }
        });
    }

    public Integer addDelta(K key, final int valueToBeAdded) {
        return this.map.compute(key, new BiFunction<K, Integer, Integer>(){

            @Override
            public Integer apply(K key, Integer origVal) {
                if (origVal == null) {
                    origVal = 0;
                }
                return InternedObjectsStore.intern((Integer)(origVal + valueToBeAdded));
            }
        });
    }

    public Integer subtract(K key, final int valueToBeDecrement) {
        return this.map.compute(key, new BiFunction<K, Integer, Integer>(){

            @Override
            public Integer apply(K key, Integer origVal) {
                if (origVal != null && (origVal = Integer.valueOf(origVal - valueToBeDecrement)) > 0) {
                    return InternedObjectsStore.intern((Integer)origVal);
                }
                return null;
            }
        });
    }

    public Integer remove(K key) {
        return this.map.remove(key);
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public Integer get(K key) {
        return this.map.get(key);
    }

    public void put(K key, Integer value) {
        this.map.put(key, value);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }
}

