/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache;

import com.appdynamics.platform.services.cache.ByteParser;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProtoParser<V extends MessageLite>
implements ByteParser<V> {
    private static final Logger logger = Logger.getLogger(ProtoParser.class.getName());
    private final Parser<V> parser;

    public ProtoParser(Parser<V> p) {
        this.parser = p;
    }

    @Override
    public V parseFrom(byte[] bytes) {
        if (this.parser != null) {
            try {
                MessageLite ret = (MessageLite)this.parser.parseFrom(bytes);
                return (V)ret;
            }
            catch (InvalidProtocolBufferException e) {
                logger.log(Level.WARNING, "ID000041 parsing failure", e);
            }
        }
        return null;
    }

    @Override
    public byte[] toBytes(V object) {
        if (object instanceof MessageLite) {
            return object.toByteArray();
        }
        return null;
    }
}

