/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache;

import com.appdynamics.platform.services.cache.CacheKeyspace;
import com.appdynamics.platform.services.cache.CacheObjectKey;
import javax.validation.constraints.NotNull;

public class CacheObjectKeyBucket {
    private CacheObjectKey[] keysForMap;
    private final CacheObjectKey.KeyBucketInvariant bucketInfo;

    public static CacheObjectKeyBucket newInstance(@NotNull CacheKeyspace keyspace, @NotNull String family, int version, Size size, Life life) {
        if (life == null) {
            life = Life.IMMORTAL;
        }
        if (size == null) {
            size = Size.LARGE;
        }
        return new CacheObjectKeyBucket(keyspace, family, version == 0 ? null : String.valueOf(version), size.getValue(), life.getMaxAgeInMinutes());
    }

    public static CacheObjectKeyBucket newInstance(@NotNull CacheKeyspace keyspace, @NotNull String family, String version, Size size, int ttlInSecs) {
        if (size == null) {
            size = Size.LARGE;
        }
        int ttlInMinutes = ttlInSecs > 0 ? ttlInSecs / 60 : -1;
        return new CacheObjectKeyBucket(keyspace, family, version, size.getValue(), ttlInMinutes);
    }

    private CacheObjectKeyBucket(@NotNull CacheKeyspace keyspace, @NotNull String family, String version, int numberOfBuckets, int ttlInMins) {
        int lifeInSeconds = ttlInMins > 0 ? ttlInMins * 60 : -1;
        this.bucketInfo = new CacheObjectKey.KeyBucketInvariant(keyspace, null, family, version, lifeInSeconds);
        if (numberOfBuckets > 0) {
            this.keysForMap = new CacheObjectKey[numberOfBuckets];
            for (int i = 0; i < numberOfBuckets; ++i) {
                this.keysForMap[i] = CacheObjectKey.newInstance(this.bucketInfo, Integer.toString(i));
            }
        }
    }

    public int getBucketSize() {
        return this.keysForMap == null ? 0 : this.keysForMap.length;
    }

    public CacheKeyspace getKeyspace() {
        return this.bucketInfo.keyspace;
    }

    public int getLifeInSeconds() {
        return this.bucketInfo.ttlInSeconds;
    }

    public String getFamily() {
        return this.bucketInfo.family;
    }

    public String getVersion() {
        return this.bucketInfo.version;
    }

    public CacheObjectKey get(long id) {
        if (this.keysForMap != null) {
            int position;
            CacheObjectKey ret;
            if (id < 0L) {
                id *= -1L;
            }
            if ((ret = this.keysForMap[position = (int)(id % (long)this.keysForMap.length)]) == null) {
                String strId = Integer.toString(position);
                this.keysForMap[position] = ret = CacheObjectKey.newInstance(this.bucketInfo, strId);
            }
            return ret;
        }
        return CacheObjectKey.newInstance(this.bucketInfo, Long.toString(id));
    }

    public CacheObjectKey get(String id) {
        if (this.keysForMap != null) {
            return this.get(id.hashCode());
        }
        return CacheObjectKey.newInstance(this.bucketInfo, id);
    }

    public String toString() {
        return "CacheObjectKeyBucket{keysForMap.length=" + (this.keysForMap == null ? null : Integer.valueOf(this.keysForMap.length)) + ", bucketInfo=" + this.bucketInfo + '}';
    }

    public static enum Life {
        ONE_MINUTE(1),
        TINY(5),
        SHORT(10),
        MEDIUM(60),
        LONG(1440),
        EXTRALONG(10080),
        IMMORTAL(-1);

        private final int maxAgeInMinutes;

        private Life(int age) {
            this.maxAgeInMinutes = age;
        }

        public int getMaxAgeInMinutes() {
            return (int)((float)this.maxAgeInMinutes * Float.parseFloat(System.getProperty(CacheObjectKeyBucket.class.getName() + ".life.multiplier", "1")));
        }
    }

    public static enum Size {
        SMALL(10),
        MEDIUM(100),
        LARGE(1000),
        HUGE(10000),
        NONE(-1);

        private final int value;

        private Size(int count) {
            this.value = count;
        }

        int getValue() {
            return this.value;
        }

        public static Size getSize(int bucketSize) {
            for (Size size : Size.values()) {
                if (bucketSize != size.getValue()) continue;
                return size;
            }
            return NONE;
        }
    }
}

