/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache;

import com.appdynamics.platform.services.cache.CacheObjectKey;
import com.google.common.base.Charsets;
import javax.validation.constraints.NotNull;

public class CacheKeyUtil {
    private static final String CACHE_OBJECT_KEY_DELIMITER = "|";

    private CacheKeyUtil() {
    }

    public static String concatenate(String leadingKey, String trailingKey) {
        return leadingKey + CACHE_OBJECT_KEY_DELIMITER + trailingKey;
    }

    protected static String getCacheKey(String partitionKey, String ... parts) {
        boolean hasPartitionKey;
        StringBuilder keyBuilder = new StringBuilder(64);
        boolean bl = hasPartitionKey = partitionKey != null;
        if (hasPartitionKey) {
            keyBuilder.append("{").append(partitionKey).append("}");
        }
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == null) continue;
            if (i > 0 || hasPartitionKey) {
                keyBuilder.append(CACHE_OBJECT_KEY_DELIMITER);
            }
            keyBuilder.append(parts[i]);
        }
        return keyBuilder.toString();
    }

    protected static String getCacheKey(@NotNull CacheObjectKey objectKey) {
        return CacheKeyUtil.getCacheKey(objectKey.getPartition(), objectKey.getKeyspace().value(), objectKey.getFamily(), objectKey.getVersion(), objectKey.getId());
    }

    protected static byte[] getCacheKeyBytes(@NotNull CacheObjectKey objectKey) {
        String key = CacheKeyUtil.getCacheKey(objectKey);
        return key.getBytes(Charsets.UTF_8);
    }

    protected static String getCacheFamilyKey(@NotNull CacheObjectKey objectKey) {
        return CacheKeyUtil.getCacheKey(objectKey.getPartition(), objectKey.getKeyspace().value(), objectKey.getFamily());
    }
}

