/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.extensions;

import com.appdynamics.voltron.extensions.ExtensionsLoader;
import com.appdynamics.voltron.extensions.ModuleLoadingException;
import com.appdynamics.voltron.extensions.api.ExtensionModule;
import com.google.inject.Module;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultExtensionsLoader
implements ExtensionsLoader {
    private static final Logger log = LoggerFactory.getLogger(DefaultExtensionsLoader.class);

    DefaultExtensionsLoader() {
    }

    @Override
    public Collection<Module> loadModulesFromJars(Collection<URL> jarUrls) {
        log.debug("Loading modules from {}", jarUrls);
        URLClassLoader classLoader = new URLClassLoader(jarUrls.toArray(new URL[jarUrls.size()]), this.getClass().getClassLoader());
        ArrayList<Module> modules = new ArrayList<Module>();
        for (URL jarUrl : jarUrls) {
            Set<Class<? extends Module>> moduleClasses = DefaultExtensionsLoader.loadClasses(classLoader, jarUrl);
            if (!moduleClasses.isEmpty()) {
                log.debug("Found module classes {} in {}", moduleClasses, (Object)jarUrl);
            }
            modules.addAll(DefaultExtensionsLoader.instantiateModules(moduleClasses, jarUrl));
        }
        return modules;
    }

    static List<Module> instantiateModules(Set<Class<? extends Module>> moduleClasses, URL jarFileUrl) {
        ArrayList<Module> modules = new ArrayList<Module>(moduleClasses.size());
        for (Class<? extends Module> modClass : moduleClasses) {
            try {
                log.debug("Instantiating {}", modClass);
                Module module = modClass.newInstance();
                modules.add(module);
            }
            catch (Exception e) {
                throw new ModuleLoadingException("Could not load extension module " + String.valueOf(modClass) + " from " + String.valueOf(jarFileUrl) + ". Make sure the module class has a public, no-args constructor.", e);
            }
        }
        log.debug("Instantiated all extension modules from {}", (Object)jarFileUrl);
        return modules;
    }

    private static Set<Class<? extends Module>> loadClasses(ClassLoader classLoader, URL jarUrl) {
        Reflections reflections = new Reflections(new Object[]{jarUrl, classLoader});
        Set annotatedClasses = reflections.getTypesAnnotatedWith(ExtensionModule.class);
        HashSet<Class<? extends Module>> moduleClasses = new HashSet<Class<? extends Module>>();
        for (Class klass : annotatedClasses) {
            if (Module.class.isAssignableFrom(klass)) {
                Class moduleClass = klass;
                moduleClasses.add(moduleClass);
                continue;
            }
            log.info("Extension from JAR {} contains a programming error. It has a non-module type ({}) that is annotated with the ExtensionModule annotation.", (Object)jarUrl, (Object)klass);
        }
        return moduleClasses;
    }
}

