/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.extensions.bridges.rest.client;

import com.appdynamics.voltron.extensions.ExtensionBindingsProvider;
import com.appdynamics.voltron.extensions.ExtensionFrameworkBindingUtils;
import com.appdynamics.voltron.extensions.bridges.rest.client.VoltronFeignClients;
import com.appdynamics.voltron.rest.client.FeignClientBuilderModule;
import com.appdynamics.voltron.rest.client.FeignServiceFactory;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;

public class ExtensionsRestClientBridgeModule
extends AbstractModule {
    private final Set<String> clientNames;

    public ExtensionsRestClientBridgeModule(Set<String> clientNames) {
        this.clientNames = ImmutableSet.copyOf(clientNames);
    }

    protected void configure() {
        MapBinder clientMapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, FeignServiceFactory.class, VoltronFeignClients.class);
        for (String clientName : this.clientNames) {
            clientMapBinder.addBinding((Object)clientName).to(FeignClientBuilderModule.getServiceFactoryKeyForClient((String)clientName));
        }
        ExtensionFrameworkBindingUtils.bindExtensionBindingsProvider((Binder)this.binder()).to(ExtensionRestClientBindingsProvider.class);
    }

    private static class ExtensionRestClientBindingsProvider
    implements ExtensionBindingsProvider {
        private final Map<String, FeignServiceFactory> clients;

        @Inject
        ExtensionRestClientBindingsProvider(@VoltronFeignClients Map<String, FeignServiceFactory> clients) {
            this.clients = clients;
        }

        public void configure(String extensionId, Binder extensionBinder) {
            for (Map.Entry<String, FeignServiceFactory> entry : this.clients.entrySet()) {
                String clientName = entry.getKey();
                FeignServiceFactory factory = entry.getValue();
                extensionBinder.bind(FeignServiceFactory.class).annotatedWith((Annotation)Names.named((String)clientName)).toInstance((Object)factory);
            }
        }
    }
}

