/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.extensions.bridges.configuration;

import com.appdynamics.voltron.configuration.ConfigurationException;
import com.appdynamics.voltron.configuration.ConfigurationListener;
import com.appdynamics.voltron.configuration.ConfigurationRegistrar;
import com.appdynamics.voltron.configuration.CustomValidator;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class ExtensionConfigurationRegistrar
implements ConfigurationRegistrar {
    private final Set<ConfigurationListenerBinding<?>> extensionListeners;
    private final Set<CustomValidatorBinding<?>> extensionValidators;
    private final ConfigurationRegistrar configurationRegistrar;

    @Inject
    ExtensionConfigurationRegistrar(ConfigurationRegistrar configurationRegistrar) {
        this.configurationRegistrar = configurationRegistrar;
        this.extensionListeners = Collections.synchronizedSet(new HashSet());
        this.extensionValidators = Collections.synchronizedSet(new HashSet());
    }

    public <T> void addConfigurationListener(String configName, Class<T> configClass, ConfigurationListener<T> configurationListener) throws InterruptedException, ConfigurationException {
        this.configurationRegistrar.addConfigurationListener(configName, configClass, configurationListener);
        this.extensionListeners.add(new ConfigurationListenerBinding<T>(configName, configClass, configurationListener));
    }

    public <T> void addCustomValidator(Class<T> configClass, CustomValidator<T> customValidator) {
        this.extensionValidators.add(new CustomValidatorBinding<T>(configClass, customValidator));
        this.configurationRegistrar.addCustomValidator(configClass, customValidator);
    }

    public <T> void removeConfigurationListener(String configName, Class<T> configClass, ConfigurationListener<T> configurationListener) {
        this.configurationRegistrar.removeConfigurationListener(configName, configClass, configurationListener);
        this.extensionListeners.remove(new ConfigurationListenerBinding<T>(configName, configClass, configurationListener));
    }

    public <T> void removeCustomValidator(Class<T> configClass, CustomValidator<T> customValidator) {
        this.configurationRegistrar.removeCustomValidator(configClass, customValidator);
        this.extensionValidators.remove(new CustomValidatorBinding<T>(configClass, customValidator));
    }

    void removeAll() {
        for (ConfigurationListenerBinding<?> configurationListenerBinding : this.extensionListeners) {
            this.configurationRegistrar.removeConfigurationListener(configurationListenerBinding.getConfigName(), configurationListenerBinding.getConfigClass(), configurationListenerBinding.getConfigurationListener());
        }
        for (CustomValidatorBinding customValidatorBinding : this.extensionValidators) {
            this.configurationRegistrar.removeCustomValidator(customValidatorBinding.getConfigClass(), customValidatorBinding.getCustomValidator());
        }
        this.extensionListeners.clear();
        this.extensionValidators.clear();
    }

    Set<ConfigurationListenerBinding<?>> getExtensionListeners() {
        return this.extensionListeners;
    }

    Set<CustomValidatorBinding<?>> getExtensionValidators() {
        return this.extensionValidators;
    }

    ConfigurationRegistrar getConfigurationRegistrar() {
        return this.configurationRegistrar;
    }

    static class ConfigurationListenerBinding<T> {
        private final String configName;
        private final Class<T> configClass;
        private final ConfigurationListener<T> configurationListener;

        public ConfigurationListenerBinding(String configName, Class<T> configClass, ConfigurationListener<T> configurationListener) {
            this.configName = configName;
            this.configClass = configClass;
            this.configurationListener = configurationListener;
        }

        public String getConfigName() {
            return this.configName;
        }

        public Class<T> getConfigClass() {
            return this.configClass;
        }

        public ConfigurationListener<T> getConfigurationListener() {
            return this.configurationListener;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigurationListenerBinding)) {
                return false;
            }
            ConfigurationListenerBinding other = (ConfigurationListenerBinding)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$configName = this.getConfigName();
            String other$configName = other.getConfigName();
            if (this$configName == null ? other$configName != null : !this$configName.equals(other$configName)) {
                return false;
            }
            Class<T> this$configClass = this.getConfigClass();
            Class<T> other$configClass = other.getConfigClass();
            if (this$configClass == null ? other$configClass != null : !this$configClass.equals(other$configClass)) {
                return false;
            }
            ConfigurationListener<T> this$configurationListener = this.getConfigurationListener();
            ConfigurationListener<T> other$configurationListener = other.getConfigurationListener();
            return !(this$configurationListener == null ? other$configurationListener != null : !this$configurationListener.equals(other$configurationListener));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigurationListenerBinding;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $configName = this.getConfigName();
            result = result * 59 + ($configName == null ? 43 : $configName.hashCode());
            Class<T> $configClass = this.getConfigClass();
            result = result * 59 + ($configClass == null ? 43 : $configClass.hashCode());
            ConfigurationListener<T> $configurationListener = this.getConfigurationListener();
            result = result * 59 + ($configurationListener == null ? 43 : $configurationListener.hashCode());
            return result;
        }

        public String toString() {
            return "ExtensionConfigurationRegistrar.ConfigurationListenerBinding(configName=" + this.getConfigName() + ", configClass=" + String.valueOf(this.getConfigClass()) + ", configurationListener=" + String.valueOf(this.getConfigurationListener()) + ")";
        }
    }

    static class CustomValidatorBinding<T> {
        private final Class<T> configClass;
        private final CustomValidator<T> customValidator;

        public CustomValidatorBinding(Class<T> configClass, CustomValidator<T> customValidator) {
            this.configClass = configClass;
            this.customValidator = customValidator;
        }

        public Class<T> getConfigClass() {
            return this.configClass;
        }

        public CustomValidator<T> getCustomValidator() {
            return this.customValidator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomValidatorBinding)) {
                return false;
            }
            CustomValidatorBinding other = (CustomValidatorBinding)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<T> this$configClass = this.getConfigClass();
            Class<T> other$configClass = other.getConfigClass();
            if (this$configClass == null ? other$configClass != null : !this$configClass.equals(other$configClass)) {
                return false;
            }
            CustomValidator<T> this$customValidator = this.getCustomValidator();
            CustomValidator<T> other$customValidator = other.getCustomValidator();
            return !(this$customValidator == null ? other$customValidator != null : !this$customValidator.equals(other$customValidator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CustomValidatorBinding;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $configClass = this.getConfigClass();
            result = result * 59 + ($configClass == null ? 43 : $configClass.hashCode());
            CustomValidator<T> $customValidator = this.getCustomValidator();
            result = result * 59 + ($customValidator == null ? 43 : $customValidator.hashCode());
            return result;
        }

        public String toString() {
            return "ExtensionConfigurationRegistrar.CustomValidatorBinding(configClass=" + String.valueOf(this.getConfigClass()) + ", customValidator=" + String.valueOf(this.getCustomValidator()) + ")";
        }
    }
}

