/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.extensions.bridges.configuration;

import com.appdynamics.voltron.configuration.Configuration;
import com.appdynamics.voltron.configuration.ConfigurationClientModule;
import com.appdynamics.voltron.configuration.ConfigurationException;
import com.appdynamics.voltron.configuration.ConfigurationListener;
import com.appdynamics.voltron.configuration.ConfigurationListenerKey;
import com.appdynamics.voltron.configuration.ConfigurationRegistrar;
import com.appdynamics.voltron.configuration.ConfigurationWriter;
import com.appdynamics.voltron.configuration.CustomValidator;
import com.appdynamics.voltron.extensions.AbstractExtensionStateListener;
import com.appdynamics.voltron.extensions.ExtensionBindingsProvider;
import com.appdynamics.voltron.extensions.bridges.configuration.ExtensionConfigurationRegistrar;
import com.appdynamics.voltron.utils.overrides.Overrider;
import com.google.common.base.Optional;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;

class ExtensionConfigBindingsProvider
extends AbstractExtensionStateListener
implements ExtensionBindingsProvider {
    private final Map<String, ExtensionConfigurationRegistrar> registrars;
    private final ConfigurationWriter configWriter;
    private final Optional<Overrider> overrider;
    private final Provider<ExtensionConfigurationRegistrar> extensionConfigurationRegistrarProvider;
    private final Object lock = new Object();

    @Inject
    ExtensionConfigBindingsProvider(ConfigurationWriter configWriter, @Configuration Optional<Overrider> overrider, Provider<ExtensionConfigurationRegistrar> extensionConfigurationRegistrarProvider) {
        this.configWriter = configWriter;
        this.overrider = overrider;
        this.extensionConfigurationRegistrarProvider = extensionConfigurationRegistrarProvider;
        this.registrars = new ConcurrentHashMap<String, ExtensionConfigurationRegistrar>();
    }

    public void configure(String extensionId, Binder extensionBinder) {
        ExtensionConfigurationRegistrar registrar = (ExtensionConfigurationRegistrar)this.extensionConfigurationRegistrarProvider.get();
        this.registrars.put(extensionId, registrar);
        extensionBinder.bind(ConfigurationWriter.class).toInstance((Object)this.configWriter);
        extensionBinder.bind(ConfigurationRegistrar.class).toInstance((Object)registrar);
        extensionBinder.bind((TypeLiteral)new TypeLiteral<Optional<Overrider>>(){}).annotatedWith(Configuration.class).toInstance(this.overrider);
        extensionBinder.install((Module)new ConfigurationClientModule(){

            protected void configureListenersAndValidators() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extensionStarted(String extensionId, Injector extensionInjector) {
        Object object = this.lock;
        synchronized (object) {
            Map extensionListeners = (Map)extensionInjector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<ConfigurationListenerKey, Set<ConfigurationListener<?>>>>(){}, Configuration.class));
            Map extensionValidators = (Map)extensionInjector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<Class<?>, Set<CustomValidator<?>>>>(){}, Configuration.class));
            ExtensionConfigurationRegistrar registrar = this.registrars.get(extensionId);
            for (Map.Entry entry : extensionValidators.entrySet()) {
                for (CustomValidator validator : (Set)entry.getValue()) {
                    try {
                        registrar.addCustomValidator((Class)entry.getKey(), validator);
                    }
                    catch (RuntimeException e) {
                        this.extensionStopping(extensionId, extensionInjector);
                        throw new RuntimeException("Could not add validator, failing then extension", e);
                    }
                }
            }
            for (Map.Entry entry : extensionListeners.entrySet()) {
                for (ConfigurationListener listener : (Set)entry.getValue()) {
                    try {
                        registrar.addConfigurationListener(((ConfigurationListenerKey)entry.getKey()).getName(), ((ConfigurationListenerKey)entry.getKey()).getConfigClass(), listener);
                    }
                    catch (ConfigurationException | InterruptedException | RuntimeException e) {
                        this.extensionStopping(extensionId, extensionInjector);
                        throw new RuntimeException("Could not add listener, failing the extension", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extensionStopping(String extensionId, Injector extensionInjector) {
        Object object = this.lock;
        synchronized (object) {
            if (this.registrars.containsKey(extensionId)) {
                this.registrars.remove(extensionId).removeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    void stop() {
        Object object = this.lock;
        synchronized (object) {
            for (ExtensionConfigurationRegistrar registrar : this.registrars.values()) {
                registrar.removeAll();
            }
            this.registrars.clear();
        }
    }

    Map<String, ExtensionConfigurationRegistrar> getRegistrars() {
        return this.registrars;
    }

    ConfigurationWriter getConfigWriter() {
        return this.configWriter;
    }

    Optional<Overrider> getOverrider() {
        return this.overrider;
    }

    Provider<ExtensionConfigurationRegistrar> getExtensionConfigurationRegistrarProvider() {
        return this.extensionConfigurationRegistrarProvider;
    }

    Object getLock() {
        return this.lock;
    }
}

