/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.configuration.providers;

import com.appdynamics.voltron.configuration.providers.Deserializer;
import com.appdynamics.voltron.configuration.providers.JsonDeserializer;
import com.appdynamics.voltron.configuration.providers.UriConfig;
import com.appdynamics.voltron.configuration.providers.UriConfigMonitor;
import com.appdynamics.voltron.configuration.providers.UriConfigProvider;
import com.appdynamics.voltron.configuration.providers.YamlDeserializer;
import com.appdynamics.voltron.utils.ManagedScheduledExecutorService;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UriConfigProviderModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(UriConfigProviderModule.class);
    private static final long DEFAULT_POLLING_PERIOD_MILLIS = 30000L;
    private static final long DEFAULT_SHUTDOWN_TIMEOUT = 10000L;

    protected final void configure() {
        this.bind(UriConfigProvider.class).asEagerSingleton();
        Multibinder monitoredUriBinder = Multibinder.newSetBinder((Binder)this.binder(), URI.class, UriConfig.class);
        this.configureMonitoredUris((Multibinder<URI>)monitoredUriBinder);
        this.configurePollingPeriod((LinkedBindingBuilder<Long>)this.bind(Long.class).annotatedWith(UriConfig.class));
        Multibinder deserializersBinder = Multibinder.newSetBinder((Binder)this.binder(), Deserializer.class, UriConfig.class);
        this.configureDeserializers((Multibinder<Deserializer>)deserializersBinder);
        this.configureHashFunction((LinkedBindingBuilder<HashFunction>)this.bind(HashFunction.class).annotatedWith(UriConfig.class));
        this.configureScheduler((LinkedBindingBuilder<ScheduledExecutorService>)this.bind(ScheduledExecutorService.class).annotatedWith(UriConfig.class));
        this.configureAdditionalBindings();
        this.bind(UriConfigMonitor.class).to(UriConfigProvider.class);
    }

    protected void configureAdditionalBindings() {
    }

    protected void configurePollingPeriod(LinkedBindingBuilder<Long> bindPollingPeriod) {
        bindPollingPeriod.toInstance((Object)30000L);
    }

    protected void configureDeserializers(Multibinder<Deserializer> deserializersBinder) {
        deserializersBinder.addBinding().to(YamlDeserializer.class);
        deserializersBinder.addBinding().to(JsonDeserializer.class);
    }

    protected void configureHashFunction(LinkedBindingBuilder<HashFunction> bindHashFunction) {
        bindHashFunction.toInstance((Object)Hashing.md5());
    }

    protected void configureScheduler(LinkedBindingBuilder<ScheduledExecutorService> bindScheduler) {
        bindScheduler.toInstance((Object)new ManagedScheduledExecutorService(){

            protected ScheduledExecutorService createDelegate() {
                return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("UriConfigPoller").build());
            }

            protected TimeUnit getTimeUnit() {
                return TimeUnit.MILLISECONDS;
            }

            protected long getShutdownTimeout() {
                return 10000L;
            }

            public String toString() {
                return "UriConfigPollerExecutorService";
            }
        });
    }

    protected abstract void configureMonitoredUris(Multibinder<URI> var1);
}

