/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.configuration;

import com.appdynamics.voltron.configuration.Configuration;
import com.appdynamics.voltron.configuration.ConfigurationException;
import com.appdynamics.voltron.configuration.ConfigurationExecutor;
import com.appdynamics.voltron.configuration.ConfigurationListener;
import com.appdynamics.voltron.configuration.ConfigurationListenerKey;
import com.appdynamics.voltron.configuration.ConfigurationMapper;
import com.appdynamics.voltron.configuration.ConfigurationProvider;
import com.appdynamics.voltron.configuration.ConfigurationRegistrar;
import com.appdynamics.voltron.configuration.ConfigurationTimeout;
import com.appdynamics.voltron.configuration.ConfigurationValidator;
import com.appdynamics.voltron.configuration.ConfigurationWriter;
import com.appdynamics.voltron.configuration.CustomValidator;
import com.appdynamics.voltron.configuration.UseConfigurationDefaultsOnStartupFailure;
import com.appdynamics.voltron.utils.ExceptionUtils;
import com.appdynamics.voltron.utils.overrides.Overrider;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationManager
implements ConfigurationWriter,
ConfigurationRegistrar {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationManager.class);
    private final Table<String, Class<?>, Set<ConfigurationListener<?>>> allListeners;
    private final SetMultimap<Class<?>, CustomValidator<?>> customValidators;
    private final Map<String, Map<String, Object>> appliedConfigurations;
    private final Validator validator;
    private final long configTimeout;
    private final ExecutorService configExecutorService;
    private final ObjectMapper mapper;
    private final Object lock = new Object();
    private final Optional<Overrider> overriderOptional;

    @Inject
    ConfigurationManager(@Configuration Map<ConfigurationListenerKey, Set<ConfigurationListener<?>>> allListeners, @Configuration Map<Class<?>, Set<CustomValidator<?>>> customValidators, @Configuration Optional<Overrider> overriderOptional, @ConfigurationValidator Validator validator, @ConfigurationTimeout long configTimeout, @ConfigurationMapper ObjectMapper mapper, @ConfigurationExecutor ExecutorService configExecutorService) {
        this.overriderOptional = overriderOptional;
        this.allListeners = HashBasedTable.create();
        for (Map.Entry<ConfigurationListenerKey, Set<ConfigurationListener<?>>> entry : allListeners.entrySet()) {
            this.allListeners.put((Object)entry.getKey().getName(), entry.getKey().getConfigClass(), new HashSet(entry.getValue()));
        }
        this.customValidators = HashMultimap.create();
        for (Map.Entry<Object, Set<Object>> entry : customValidators.entrySet()) {
            this.customValidators.putAll((Object)((Class)entry.getKey()), (Iterable)entry.getValue());
        }
        this.validator = validator;
        this.configTimeout = configTimeout;
        this.mapper = mapper;
        this.configExecutorService = configExecutorService;
        this.appliedConfigurations = new HashMap<String, Map<String, Object>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRawConfiguration(String name, Map<String, Object> rawConfigData) throws ConfigurationException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.debugLog("Building configuration types for '{}' -> {}", name, rawConfigData);
            Set configTypes = this.allListeners.row((Object)name).keySet();
            HashMap configurations = new HashMap(configTypes.size());
            for (Class configType : configTypes) {
                log.debug("Verifying config '{}' as type {}", (Object)name, (Object)configType);
                configurations.put(configType, this.build(name, configType, rawConfigData));
            }
            this.appliedConfigurations.put(name, rawConfigData);
            HashMap failedListeners = new HashMap();
            HashSet timedOutListeners = new HashSet();
            for (Map.Entry<Class<?>, Object> entry : configurations.entrySet()) {
                this.debugLog("Applying '{}'", entry);
                try {
                    this.apply(name, entry.getValue(), entry.getKey());
                }
                catch (ConfigurationException e) {
                    failedListeners.putAll(e.getFailedListeners());
                    timedOutListeners.addAll(e.getTimedOutListeners());
                }
            }
            if (failedListeners.size() > 0 || timedOutListeners.size() > 0) {
                String msg = this.buildConfigurationExceptionMessage(rawConfigData, failedListeners, timedOutListeners);
                throw new ConfigurationException(msg, failedListeners, timedOutListeners);
            }
        }
    }

    @Override
    public void writeConfiguration(String name, Object configData) throws ConfigurationException, InterruptedException, IOException {
        Map rawConfig = (Map)this.mapper.convertValue(configData, (TypeReference)new TypeReference<Map<String, Object>>(){});
        this.writeRawConfiguration(name, rawConfig);
    }

    private String buildConfigurationExceptionMessage(Map<String, Object> rawConfigData, Map<ConfigurationListener<?>, Throwable> failedListeners, Set<ConfigurationListener<?>> timedOutListeners) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to apply configuration '").append(rawConfigData).append("':");
        if (failedListeners.size() > 0) {
            sb.append("\n    The following listeners failed:\n");
            i = 0;
            for (Map.Entry entry : failedListeners.entrySet()) {
                sb.append("        ").append(i++).append(". ").append(entry.getKey()).append("\n            ").append(ExceptionUtils.toString((Throwable)((Throwable)entry.getValue())).replace("\t", "            ")).append("\n");
            }
        }
        if (timedOutListeners.size() > 0) {
            sb.append("\n    The following listeners timed out:\n");
            i = 0;
            for (Object object : timedOutListeners) {
                sb.append("        ").append(i++).append(". ").append(object).append('\n');
            }
        }
        return sb.toString();
    }

    private <T> T build(String name, Class<T> configDataClass, Map<String, Object> rawData) {
        Set violations;
        Object configData = this.mapper.convertValue(rawData, configDataClass);
        if (this.overriderOptional.isPresent()) {
            ((Overrider)this.overriderOptional.get()).override(configData);
        }
        if ((violations = this.validator.validate(configData, new Class[0])).size() > 0) {
            String msg = ConfigurationManager.buildValidationExceptionMessage(name, configDataClass, rawData, violations);
            throw new ConstraintViolationException(msg, violations);
        }
        Set validatorsForType = this.customValidators.get(configDataClass);
        if (validatorsForType != null) {
            Iterator iterator = validatorsForType.iterator();
            while (iterator.hasNext()) {
                CustomValidator customValidator;
                CustomValidator v = customValidator = (CustomValidator)iterator.next();
                this.validateWithCustomValidator(name, configData, v);
            }
        }
        return (T)configData;
    }

    private <T> void validateWithCustomValidator(String name, T configData, CustomValidator<T> customValidator) {
        try {
            customValidator.validate(name, configData);
        }
        catch (ConstraintViolationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Custom validator " + String.valueOf(customValidator) + " threw an unexpected exception", e);
        }
    }

    private void apply(String name, Object configData, Class<?> configType) throws InterruptedException, ConfigurationException {
        Set listeners = (Set)this.allListeners.get((Object)name, configType);
        if (listeners == null) {
            log.debug("No listeners found for {}, {}", (Object)name, configType);
            return;
        }
        HashMap failedListeners = new HashMap();
        HashSet timedOutListeners = new HashSet();
        this.debugLog("Applying configuration '{}': {}", name, configData);
        for (ConfigurationListener configListener : listeners) {
            if (!ConfigurationProvider.class.isInstance(configListener)) continue;
            this.executeListener(configListener, name, configData, failedListeners, timedOutListeners);
        }
        for (ConfigurationListener configListener : listeners) {
            if (ConfigurationProvider.class.isInstance(configListener)) continue;
            this.executeListener(configListener, name, configData, failedListeners, timedOutListeners);
        }
        if (failedListeners.size() != 0 || timedOutListeners.size() != 0) {
            throw new ConfigurationException("Failed to apply config.", failedListeners, timedOutListeners);
        }
    }

    private <T> void apply(final String name, final T configData, final ConfigurationListener<T> configListener) throws InterruptedException, ExecutionException, TimeoutException {
        log.debug("Applying configuration '{}' to {}", (Object)name, configListener);
        Future<?> future = this.configExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                configListener.apply(name, configData);
            }
        });
        try {
            future.get(this.configTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.debug("Interrupted", (Throwable)e);
            future.cancel(true);
            Thread.currentThread().interrupt();
            throw e;
        }
        catch (ExecutionException e) {
            log.debug("Failed to apply", (Throwable)e);
            throw e;
        }
        catch (TimeoutException e) {
            log.debug("Timed out while applying", (Throwable)e);
            future.cancel(true);
            throw e;
        }
    }

    private static <T> String buildValidationExceptionMessage(String name, Class<T> configDataClass, Map<String, Object> rawData, Set<ConstraintViolation<T>> violations) {
        StringBuilder sb = new StringBuilder("Error occurred while validating configuration [").append(name).append("]\n    deserialized as type [").append(configDataClass.getName()).append("]\n    with config [").append(rawData.toString()).append("]\n");
        for (ConstraintViolation<T> violation : violations) {
            sb.append("    property '").append(violation.getPropertyPath()).append("' ").append(violation.getMessage()).append(". Found value '").append(violation.getInvalidValue()).append("'.").append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addConfigurationListener(String configName, Class<T> configClass, ConfigurationListener<T> configurationListener) throws InterruptedException, ConfigurationException {
        Object object = this.lock;
        synchronized (object) {
            HashSet<ConfigurationListener<T>> configurationListeners;
            Map<String, Object> rawConfig = this.appliedConfigurations.get(configName);
            if (rawConfig != null) {
                T config = null;
                try {
                    config = this.build(configName, configClass, rawConfig);
                }
                catch (IllegalArgumentException e) {
                    config = this.useDefaultsOnFailureIfSpecified(configClass, e);
                }
                try {
                    this.apply(configName, config, configurationListener);
                }
                catch (ExecutionException e) {
                    throw new ConfigurationException("Failed to apply configuration " + configName + " on listener " + String.valueOf(configurationListener) + " when dynamically added.", Collections.singletonMap(configurationListener, e.getCause()), Collections.emptySet());
                }
                catch (TimeoutException e) {
                    throw new ConfigurationException("Timed out applying configuration " + configName + " on listener " + String.valueOf(configurationListener) + " when dynamically added.", Collections.emptyMap(), Collections.singleton(configurationListener));
                }
            }
            if ((configurationListeners = (HashSet<ConfigurationListener<T>>)this.allListeners.get((Object)configName, configClass)) == null) {
                configurationListeners = new HashSet<ConfigurationListener<T>>();
                this.allListeners.put((Object)configName, configClass, configurationListeners);
            }
            configurationListeners.add(configurationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addCustomValidator(Class<T> configClass, CustomValidator<T> customValidator) {
        Object object = this.lock;
        synchronized (object) {
            Set configNamesForType = this.allListeners.column(configClass).keySet();
            for (String name : configNamesForType) {
                log.debug("Verifying config '{}' as type {}", (Object)name, configClass);
                Map<String, Object> rawConfigData = this.appliedConfigurations.get(name);
                if (rawConfigData == null) continue;
                T config = this.build(name, configClass, rawConfigData);
                this.validateWithCustomValidator(name, config, customValidator);
            }
            this.customValidators.put(configClass, customValidator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void removeConfigurationListener(String configName, Class<T> configClass, ConfigurationListener<T> configurationListener) {
        Object object = this.lock;
        synchronized (object) {
            Set configurationListeners = (Set)this.allListeners.get((Object)configName, configClass);
            if (configurationListeners != null) {
                configurationListeners.remove(configurationListener);
                if (configurationListeners.isEmpty()) {
                    this.allListeners.remove((Object)configName, configClass);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void removeCustomValidator(Class<T> configClass, CustomValidator<T> customValidator) {
        Object object = this.lock;
        synchronized (object) {
            this.customValidators.remove(configClass, customValidator);
        }
    }

    @Override
    public boolean isAnyListenerForConfig(String name) {
        return this.allListeners.containsRow((Object)name);
    }

    private void executeListener(ConfigurationListener<?> configListener, String name, Object configData, Map<ConfigurationListener<?>, Throwable> failedListeners, Set<ConfigurationListener<?>> timedOutListeners) throws InterruptedException, ConfigurationException {
        ConfigurationListener<?> l = configListener;
        try {
            this.apply(name, configData, l);
        }
        catch (ExecutionException e) {
            failedListeners.put(configListener, e.getCause());
        }
        catch (TimeoutException e) {
            timedOutListeners.add(configListener);
        }
    }

    private <T> T useDefaultsOnFailureIfSpecified(Class<T> configClass, IllegalArgumentException exception) throws ConfigurationException {
        UseConfigurationDefaultsOnStartupFailure annotation = configClass.getAnnotation(UseConfigurationDefaultsOnStartupFailure.class);
        if (annotation == null) {
            throw exception;
        }
        log.error("Failed to read configuration for " + configClass.getName() + " at startup.  Using class defaults.");
        StringBuilder builder = new StringBuilder();
        builder.append("\n\n================================================\n\n").append("    There is an issue with the configuration file for\n").append("    ").append(configClass.getSimpleName()).append("\n").append("    The problem is:\n").append("    ").append(exception.getMessage()).append("\n").append("    Will be using system defaults for now.\n").append("    Please fix the errors to get your configuration loaded!").append("\n\n================================================\n");
        log.error(builder.toString());
        try {
            return configClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Failed to use specified configuration for: " + configClass.getName() + " using Defaults", Collections.emptyMap(), Collections.emptySet());
        }
    }

    private void debugLog(String message, String name, Map<String, Object> rawConfigData) {
        HashMap<String, Object> logConfigData = new HashMap<String, Object>(rawConfigData);
        logConfigData.replace("accountKey", "****");
        log.debug(message, (Object)name, logConfigData);
    }

    private void debugLog(String message, Map.Entry<Class<?>, Object> configEntry) {
        AbstractMap.SimpleEntry logEntry = new AbstractMap.SimpleEntry(configEntry.getKey(), configEntry.getValue());
        logEntry.setValue(logEntry.getValue().toString().replaceAll("accountKey=[A-Za-z0-9-]+", "accountKey=****"));
        log.debug(message, logEntry);
    }

    private void debugLog(String message, String name, Object configData) {
        String logConfigData = configData.toString().replaceAll("accountKey=[A-Za-z0-9-]+", "accountKey=****");
        log.debug("Applying configuration '{}': {}", (Object)name, (Object)logConfigData);
    }

    public String toString() {
        return "ConfigurationManager(allListeners=" + String.valueOf(this.getAllListeners()) + ")";
    }

    Table<String, Class<?>, Set<ConfigurationListener<?>>> getAllListeners() {
        return this.allListeners;
    }
}

