/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.configuration;

import com.appdynamics.voltron.configuration.ConfigurationListener;
import com.appdynamics.voltron.configuration.ConfigurationListenerKey;
import com.appdynamics.voltron.configuration.ConfigurationProvider;
import com.appdynamics.voltron.configuration.CustomValidator;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;

abstract class AnnotatedConfigurationClientModule
extends AbstractModule {
    private final Class<? extends Annotation> annotation;
    private MapBinder<ConfigurationListenerKey, ConfigurationListener<?>> listenersBinder;
    private MapBinder<Class<?>, CustomValidator<?>> validatorsBinder;

    public AnnotatedConfigurationClientModule(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    protected final void configure() {
        this.listenersBinder = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(ConfigurationListenerKey.class), (TypeLiteral)new TypeLiteral<ConfigurationListener<?>>(){}, this.annotation).permitDuplicates();
        this.validatorsBinder = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<CustomValidator<?>>(){}, this.annotation).permitDuplicates();
        this.configureListenersAndValidators();
    }

    protected abstract void configureListenersAndValidators();

    protected <T> void bindInjectableConfig(String name, Class<T> configClass, T initialValue, boolean makeDefault) {
        ConfigurationProvider<T> configurationProvider = new ConfigurationProvider<T>(initialValue);
        this.requestInjection(configurationProvider);
        this.bind(configClass).annotatedWith((Annotation)Names.named((String)name)).toProvider(configurationProvider);
        if (makeDefault) {
            this.bind(configClass).toProvider(configurationProvider);
        }
        this.bindConfigListener(name, configClass).toInstance(configurationProvider);
    }

    protected <T> LinkedBindingBuilder<ConfigurationListener<? extends T>> bindConfigListener(String name, Class<T> configClass) {
        return this.listenersBinder.addBinding((Object)new ConfigurationListenerKey(name, configClass));
    }

    protected <T> LinkedBindingBuilder<CustomValidator<? extends T>> bindCustomValidator(Class<T> configClass) {
        return this.validatorsBinder.addBinding(configClass);
    }

    Class<? extends Annotation> getAnnotation() {
        return this.annotation;
    }
}

