/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.netviz.common.constants.metrics;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetVizMetricsHelper {
    public static final List<String> FLOW_MAP_KPI_METRICS = Collections.unmodifiableList(Arrays.asList("Latency - RTT (usec)", "# PIE Events", "# Errors"));
    public static final List<String> FLOW_KPI_METRICS = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("Latency - RTT (usec)", "Loss (per mille)", "Throughput (Bps)", "# PIE Events", "# Errors")));
    public static final List<String> HOST_KPI_METRICS = Collections.unmodifiableList(Arrays.asList("Established", "Wait", "TimeWait", "Embryonic"));
    public static final List<String> NETWORK_ELEMENT_METRICS = Collections.unmodifiableList(Arrays.asList("Current Connections", "Max Connections", "Incoming MB Per Minute", "Mean Connection Duration (ms)", "Outgoing MB Per Minute"));
    public static final List<String> NETWORK_ELEMENT_TCP_METRICS = Collections.unmodifiableList(Arrays.asList("Abandons", "Accept", "Accept Fails", "Connect", "Connect Fails", "Expire", "Rx Rst", "Rx Bad Segment", "Rx OO Segment", "TX Rexmit"));
    public static final List<String> NETWORK_ELEMENT_HTTP_METRICS = Collections.unmodifiableList(Arrays.asList("Total Request", "Total Get Requests", "Response 2xx", "Response 3xx", "Response 4xx", "Response 5xx"));
    public static final List<String> NETWORK_ELEMENT_NODE_METRICS = Collections.unmodifiableList(Arrays.asList("Calls Per Minute"));
    public static final Map<String, String> PATTERN_BY_HOST_METRICS_NAMES_MAP;
    public static final Set<String> CACHEABLE_METRICS;

    public static boolean isCacheableMetric(String simpleMetricName) {
        return simpleMetricName != null && CACHEABLE_METRICS.contains(simpleMetricName);
    }

    public static List<String> getCacheableNodeLevelMetricPaths() {
        ArrayList<String> cacheableMetricPaths = new ArrayList<String>();
        for (String metricName : CACHEABLE_METRICS) {
            cacheableMetricPaths.add(MessageFormat.format("ADVANCED_NETWORK|Flows|{0}", metricName));
        }
        return cacheableMetricPaths;
    }

    public static String getNodeNameFromMetricPath(String metricPath) {
        String[] pathTokens = metricPath.split("\\|");
        if (pathTokens.length > 2) {
            int nodeIndex = pathTokens.length - 2;
            return pathTokens[nodeIndex].split("\\[")[0];
        }
        return null;
    }

    public static String getMetricDisplayName(String metricPattern, String metricPath) {
        return MessageFormat.format(metricPattern.replaceFirst("ADVANCED_NETWORK", "Advanced Network"), metricPath);
    }

    public static String getMetricMonitorNameForDisplayName(String metricPath) {
        return metricPath == null ? null : metricPath.replaceFirst("Advanced Network", "ADVANCED_NETWORK");
    }

    static {
        CACHEABLE_METRICS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("# PIE Events", "# Errors", "# Client Limited", "# Client Zero Window", "# Retransmission Timeouts", "# Server Limited", "# Server Zero Window", "# Fin Errors", "# Syn Resets", "# Syn Blackholes", "# TCP Resets - Established", "Throughput (Bps)", "# Connection Requests", "# Connection Errors", "# Flows - TCP Resets", "# Current Established Connections", "Loss (per mille)", "# Data Retransmits", "# SACK Retransmits", "TCP Handshake (usec)", "Initial RTT (usec)", "Latency - RTT (usec)", "Lifetime (usec)")));
        HashMap<String, String> metricPathsByName = new HashMap<String, String>();
        metricPathsByName.put("Established", "ADVANCED_NETWORK|Host|Socket|{0}");
        metricPathsByName.put("Embryonic", "ADVANCED_NETWORK|Host|Socket|{0}");
        metricPathsByName.put("TimeWait", "ADVANCED_NETWORK|Host|Socket|{0}");
        metricPathsByName.put("Wait", "ADVANCED_NETWORK|Host|Socket|{0}");
        metricPathsByName.put("Availability", "ADVANCED_NETWORK|Agent|{0}");
        metricPathsByName.put("# Collisions", "ADVANCED_NETWORK|Host|Interface|{0}");
        metricPathsByName.put("# Receive Errors", "ADVANCED_NETWORK|Host|Interface|{0}");
        metricPathsByName.put("# Transmit Errors", "ADVANCED_NETWORK|Host|Interface|{0}");
        metricPathsByName.put("# Total Errors", "ADVANCED_NETWORK|Host|Interface|{0}");
        metricPathsByName.put("Packets Dropped Per Sec", "ADVANCED_NETWORK|Host|PCAP|Interface|{0}");
        metricPathsByName.put("Packets Received Per Sec", "ADVANCED_NETWORK|Host|PCAP|Interface|{0}");
        PATTERN_BY_HOST_METRICS_NAMES_MAP = Collections.unmodifiableMap(metricPathsByName);
    }
}

