/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.common.biz.shared.machines;

import com.appdynamics.sim.common.biz.shared.machines.AssemblyDescriptorConstants;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AssemblyDescriptors {
    public static final String CONFIG_NAME = "_descriptorConfig";
    @JsonProperty
    private ImmutableMap<String, Revision> descriptors;
    public static final ImmutableMap<String, Revision> DEFAULT_DESCRIPTORS;

    @JsonCreator
    public AssemblyDescriptors(@JsonProperty(value="descriptors") ImmutableMap<String, Revision> descriptors) {
        this.descriptors = descriptors == null ? ImmutableMap.of() : descriptors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ImmutableMap<String, Revision> getDescriptors() {
        return this.descriptors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssemblyDescriptors)) {
            return false;
        }
        AssemblyDescriptors other = (AssemblyDescriptors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableMap<String, Revision> this$descriptors = this.getDescriptors();
        ImmutableMap<String, Revision> other$descriptors = other.getDescriptors();
        return !(this$descriptors == null ? other$descriptors != null : !this$descriptors.equals(other$descriptors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssemblyDescriptors;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableMap<String, Revision> $descriptors = this.getDescriptors();
        result = result * 59 + ($descriptors == null ? 43 : $descriptors.hashCode());
        return result;
    }

    public String toString() {
        return "AssemblyDescriptors(descriptors=" + this.getDescriptors() + ")";
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AssemblyDescriptorConstants descriptor : AssemblyDescriptorConstants.values()) {
            builder.put((Object)descriptor.getName(), (Object)new Revision(descriptor.getMajorRevision()));
        }
        DEFAULT_DESCRIPTORS = builder.build();
    }

    public static class Builder {
        @NonNull
        ImmutableMap<String, Revision> descriptors;

        public AssemblyDescriptors build() {
            if (this.descriptors == null) {
                this.descriptors = DEFAULT_DESCRIPTORS;
            }
            return new AssemblyDescriptors(this.descriptors);
        }

        public Builder emptyDescriptors() {
            this.descriptors = ImmutableMap.of();
            return this;
        }

        public Builder descriptors(@NonNull ImmutableMap<String, Revision> descriptors) {
            if (descriptors == null) {
                throw new NullPointerException("descriptors is marked non-null but is null");
            }
            this.descriptors = descriptors;
            return this;
        }
    }

    public static class Revision {
        private final ImmutableSet<Integer> majorRevision;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Revision)) {
                return false;
            }
            Revision other = (Revision)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ImmutableSet<Integer> this$majorRevision = this.getMajorRevision();
            ImmutableSet<Integer> other$majorRevision = other.getMajorRevision();
            return !(this$majorRevision == null ? other$majorRevision != null : !this$majorRevision.equals(other$majorRevision));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Revision;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ImmutableSet<Integer> $majorRevision = this.getMajorRevision();
            result = result * 59 + ($majorRevision == null ? 43 : $majorRevision.hashCode());
            return result;
        }

        public Revision(ImmutableSet<Integer> majorRevision) {
            this.majorRevision = majorRevision;
        }

        public ImmutableSet<Integer> getMajorRevision() {
            return this.majorRevision;
        }
    }
}

