/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.common.biz.shared.machines;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AgentRegistrationSupplementalRequest {
    public static final String CONFIG_NAME = "_agentRegistrationSupplementalConfig";
    public static final String SIM_MACHINE_TYPE = "simMachineType";
    public static final String HOST_SIM_MACHINE_ID = "hostSimMachineId";
    public static final String HOST_NAME = "hostName";
    public static final String CONTAINER_TYPE = "containerType";
    @JsonProperty
    private final Optional<Long> hostSimMachineId;
    @JsonProperty
    private final String simMachineType;
    @JsonProperty
    private final boolean historical;
    @JsonProperty
    private final Optional<String> hostName;
    @JsonProperty
    private final String containerType;

    @JsonCreator
    public AgentRegistrationSupplementalRequest(@JsonProperty(value="simMachineType") String simMachineType, @JsonProperty(value="hostSimMachineId") Optional<Long> hostSimMachineIdOptional, @JsonProperty(value="historical") boolean historical, @JsonProperty(value="hostName") Optional<String> hostNameOptional, @JsonProperty(value="containerType") String containerType) {
        this.hostSimMachineId = hostSimMachineIdOptional != null && hostSimMachineIdOptional.isPresent() ? hostSimMachineIdOptional : Optional.absent();
        this.simMachineType = simMachineType;
        this.historical = historical;
        this.hostName = hostNameOptional != null && hostNameOptional.isPresent() ? hostNameOptional : Optional.absent();
        this.containerType = containerType;
    }

    public static Builder builder(@NonNull String simMachineType, @NonNull Optional<Long> hostSimMachineIdOptional, @NonNull Optional<String> hostNameOptional) {
        if (simMachineType == null) {
            throw new NullPointerException("simMachineType is marked non-null but is null");
        }
        if (hostSimMachineIdOptional == null) {
            throw new NullPointerException("hostSimMachineIdOptional is marked non-null but is null");
        }
        if (hostNameOptional == null) {
            throw new NullPointerException("hostNameOptional is marked non-null but is null");
        }
        return new Builder(simMachineType, hostSimMachineIdOptional, hostNameOptional);
    }

    public Optional<Long> getHostSimMachineId() {
        return this.hostSimMachineId;
    }

    public String getSimMachineType() {
        return this.simMachineType;
    }

    public boolean isHistorical() {
        return this.historical;
    }

    public Optional<String> getHostName() {
        return this.hostName;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentRegistrationSupplementalRequest)) {
            return false;
        }
        AgentRegistrationSupplementalRequest other = (AgentRegistrationSupplementalRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHistorical() != other.isHistorical()) {
            return false;
        }
        Optional<Long> this$hostSimMachineId = this.getHostSimMachineId();
        Optional<Long> other$hostSimMachineId = other.getHostSimMachineId();
        if (this$hostSimMachineId == null ? other$hostSimMachineId != null : !this$hostSimMachineId.equals(other$hostSimMachineId)) {
            return false;
        }
        String this$simMachineType = this.getSimMachineType();
        String other$simMachineType = other.getSimMachineType();
        if (this$simMachineType == null ? other$simMachineType != null : !this$simMachineType.equals(other$simMachineType)) {
            return false;
        }
        Optional<String> this$hostName = this.getHostName();
        Optional<String> other$hostName = other.getHostName();
        if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
            return false;
        }
        String this$containerType = this.getContainerType();
        String other$containerType = other.getContainerType();
        return !(this$containerType == null ? other$containerType != null : !this$containerType.equals(other$containerType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgentRegistrationSupplementalRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHistorical() ? 79 : 97);
        Optional<Long> $hostSimMachineId = this.getHostSimMachineId();
        result = result * 59 + ($hostSimMachineId == null ? 43 : $hostSimMachineId.hashCode());
        String $simMachineType = this.getSimMachineType();
        result = result * 59 + ($simMachineType == null ? 43 : $simMachineType.hashCode());
        Optional<String> $hostName = this.getHostName();
        result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
        String $containerType = this.getContainerType();
        result = result * 59 + ($containerType == null ? 43 : $containerType.hashCode());
        return result;
    }

    public String toString() {
        return "AgentRegistrationSupplementalRequest(hostSimMachineId=" + this.getHostSimMachineId() + ", simMachineType=" + this.getSimMachineType() + ", historical=" + this.isHistorical() + ", hostName=" + this.getHostName() + ", containerType=" + this.getContainerType() + ")";
    }

    public static class Builder {
        @NonNull
        private final String simMachineType;
        @NonNull
        private final Optional<Long> hostSimMachineIdOptional;
        private boolean historical = false;
        @NonNull
        private final Optional<String> hostNameOptional;
        private String containerType;

        public AgentRegistrationSupplementalRequest build() {
            return new AgentRegistrationSupplementalRequest(this.simMachineType, this.hostSimMachineIdOptional, this.historical, this.hostNameOptional, this.containerType);
        }

        public Builder historical(boolean historical) {
            this.historical = historical;
            return this;
        }

        public Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        private Builder(@NonNull String simMachineType, @NonNull Optional<Long> hostSimMachineIdOptional, @NonNull Optional<String> hostNameOptional) {
            if (simMachineType == null) {
                throw new NullPointerException("simMachineType is marked non-null but is null");
            }
            if (hostSimMachineIdOptional == null) {
                throw new NullPointerException("hostSimMachineIdOptional is marked non-null but is null");
            }
            if (hostNameOptional == null) {
                throw new NullPointerException("hostNameOptional is marked non-null but is null");
            }
            this.simMachineType = simMachineType;
            this.hostSimMachineIdOptional = hostSimMachineIdOptional;
            this.hostNameOptional = hostNameOptional;
        }
    }
}

