/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.common.biz.shared.machines;

import com.appdynamics.sim.common.biz.shared.constants.AgentType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Set;
import lombok.NonNull;

public class AgentRegistrationRequest {
    public static final String CONFIG_NAME = "_agentRegistrationRequestConfig";
    @JsonProperty
    @NonNull
    private final String machineInfo;
    @JsonProperty
    @NonNull
    private final String jvmInfo;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Boolean sapMachine;
    @JsonProperty
    @NonNull
    private final String installDirectory;
    @JsonProperty
    @NonNull
    private final String agentVersion;
    @JsonProperty
    private final String tierName;
    @JsonProperty
    private final String nodeName;
    @JsonProperty
    private final Set<String> applicationNames;
    @JsonProperty
    private final boolean autoRegisterAgent;
    @JsonProperty
    private final AgentType agentType;

    @JsonCreator
    public AgentRegistrationRequest(@JsonProperty(value="machineInfo") String machineInfo, @JsonProperty(value="jvmInfo") String jvmInfo, @JsonProperty(value="installDirectory") String installDirectory, @JsonProperty(value="agentVersion") String agentVersion, @JsonProperty(value="tierName") String tierName, @JsonProperty(value="nodeName") String nodeName, @JsonProperty(value="applicationNames") Set<String> applicationNames, @JsonProperty(value="autoRegisterAgent") boolean autoRegisterAgent, @JsonProperty(value="sapMachine") Boolean sapMachine, @JsonProperty(value="agentType") AgentType agentType) {
        this.machineInfo = machineInfo;
        this.jvmInfo = jvmInfo;
        this.installDirectory = installDirectory;
        this.agentVersion = agentVersion;
        this.tierName = tierName;
        this.nodeName = nodeName;
        this.applicationNames = applicationNames == null ? Collections.emptySet() : applicationNames;
        this.autoRegisterAgent = autoRegisterAgent;
        this.sapMachine = sapMachine;
        this.agentType = agentType == null ? AgentType.MACHINE_AGENT : agentType;
    }

    public static Builder builder(@NonNull String machineInfo, @NonNull String jvmInfo, @NonNull String installDirectory, @NonNull String agentVersion) {
        if (machineInfo == null) {
            throw new NullPointerException("machineInfo is marked non-null but is null");
        }
        if (jvmInfo == null) {
            throw new NullPointerException("jvmInfo is marked non-null but is null");
        }
        if (installDirectory == null) {
            throw new NullPointerException("installDirectory is marked non-null but is null");
        }
        if (agentVersion == null) {
            throw new NullPointerException("agentVersion is marked non-null but is null");
        }
        return new Builder(machineInfo, jvmInfo, installDirectory, agentVersion);
    }

    @NonNull
    public String getMachineInfo() {
        return this.machineInfo;
    }

    @NonNull
    public String getJvmInfo() {
        return this.jvmInfo;
    }

    public Boolean getSapMachine() {
        return this.sapMachine;
    }

    @NonNull
    public String getInstallDirectory() {
        return this.installDirectory;
    }

    @NonNull
    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getTierName() {
        return this.tierName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Set<String> getApplicationNames() {
        return this.applicationNames;
    }

    public boolean isAutoRegisterAgent() {
        return this.autoRegisterAgent;
    }

    public AgentType getAgentType() {
        return this.agentType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentRegistrationRequest)) {
            return false;
        }
        AgentRegistrationRequest other = (AgentRegistrationRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoRegisterAgent() != other.isAutoRegisterAgent()) {
            return false;
        }
        Boolean this$sapMachine = this.getSapMachine();
        Boolean other$sapMachine = other.getSapMachine();
        if (this$sapMachine == null ? other$sapMachine != null : !((Object)this$sapMachine).equals(other$sapMachine)) {
            return false;
        }
        String this$machineInfo = this.getMachineInfo();
        String other$machineInfo = other.getMachineInfo();
        if (this$machineInfo == null ? other$machineInfo != null : !this$machineInfo.equals(other$machineInfo)) {
            return false;
        }
        String this$jvmInfo = this.getJvmInfo();
        String other$jvmInfo = other.getJvmInfo();
        if (this$jvmInfo == null ? other$jvmInfo != null : !this$jvmInfo.equals(other$jvmInfo)) {
            return false;
        }
        String this$installDirectory = this.getInstallDirectory();
        String other$installDirectory = other.getInstallDirectory();
        if (this$installDirectory == null ? other$installDirectory != null : !this$installDirectory.equals(other$installDirectory)) {
            return false;
        }
        String this$agentVersion = this.getAgentVersion();
        String other$agentVersion = other.getAgentVersion();
        if (this$agentVersion == null ? other$agentVersion != null : !this$agentVersion.equals(other$agentVersion)) {
            return false;
        }
        String this$tierName = this.getTierName();
        String other$tierName = other.getTierName();
        if (this$tierName == null ? other$tierName != null : !this$tierName.equals(other$tierName)) {
            return false;
        }
        String this$nodeName = this.getNodeName();
        String other$nodeName = other.getNodeName();
        if (this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName)) {
            return false;
        }
        Set<String> this$applicationNames = this.getApplicationNames();
        Set<String> other$applicationNames = other.getApplicationNames();
        if (this$applicationNames == null ? other$applicationNames != null : !((Object)this$applicationNames).equals(other$applicationNames)) {
            return false;
        }
        AgentType this$agentType = this.getAgentType();
        AgentType other$agentType = other.getAgentType();
        return !(this$agentType == null ? other$agentType != null : !((Object)((Object)this$agentType)).equals((Object)other$agentType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgentRegistrationRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoRegisterAgent() ? 79 : 97);
        Boolean $sapMachine = this.getSapMachine();
        result = result * 59 + ($sapMachine == null ? 43 : ((Object)$sapMachine).hashCode());
        String $machineInfo = this.getMachineInfo();
        result = result * 59 + ($machineInfo == null ? 43 : $machineInfo.hashCode());
        String $jvmInfo = this.getJvmInfo();
        result = result * 59 + ($jvmInfo == null ? 43 : $jvmInfo.hashCode());
        String $installDirectory = this.getInstallDirectory();
        result = result * 59 + ($installDirectory == null ? 43 : $installDirectory.hashCode());
        String $agentVersion = this.getAgentVersion();
        result = result * 59 + ($agentVersion == null ? 43 : $agentVersion.hashCode());
        String $tierName = this.getTierName();
        result = result * 59 + ($tierName == null ? 43 : $tierName.hashCode());
        String $nodeName = this.getNodeName();
        result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
        Set<String> $applicationNames = this.getApplicationNames();
        result = result * 59 + ($applicationNames == null ? 43 : ((Object)$applicationNames).hashCode());
        AgentType $agentType = this.getAgentType();
        result = result * 59 + ($agentType == null ? 43 : ((Object)((Object)$agentType)).hashCode());
        return result;
    }

    public String toString() {
        return "AgentRegistrationRequest(machineInfo=" + this.getMachineInfo() + ", jvmInfo=" + this.getJvmInfo() + ", sapMachine=" + this.getSapMachine() + ", installDirectory=" + this.getInstallDirectory() + ", agentVersion=" + this.getAgentVersion() + ", tierName=" + this.getTierName() + ", nodeName=" + this.getNodeName() + ", applicationNames=" + this.getApplicationNames() + ", autoRegisterAgent=" + this.isAutoRegisterAgent() + ", agentType=" + (Object)((Object)this.getAgentType()) + ")";
    }

    public static class Builder {
        @NonNull
        private final String machineInfo;
        @NonNull
        private final String jvmInfo;
        @NonNull
        private final String installDirectory;
        @NonNull
        private final String agentVersion;
        private String tierName;
        private String nodeName;
        private Set<String> applicationNames;
        private boolean autoRegisterAgent = true;
        private Boolean sapMachine;
        private AgentType agentType = AgentType.MACHINE_AGENT;

        public AgentRegistrationRequest build() {
            return new AgentRegistrationRequest(this.machineInfo, this.jvmInfo, this.installDirectory, this.agentVersion, this.tierName, this.nodeName, this.applicationNames, this.autoRegisterAgent, this.sapMachine, this.agentType);
        }

        public Builder tierName(String tierName) {
            this.tierName = tierName;
            return this;
        }

        public Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public Builder applicationNames(Set<String> applicationNames) {
            this.applicationNames = applicationNames;
            return this;
        }

        public Builder autoRegisterAgent(boolean autoRegisterAgent) {
            this.autoRegisterAgent = autoRegisterAgent;
            return this;
        }

        public Builder sapMachine(Boolean sapMachine) {
            this.sapMachine = sapMachine;
            return this;
        }

        public Builder agentType(AgentType agentType) {
            this.agentType = agentType;
            return this;
        }

        private Builder(@NonNull String machineInfo, @NonNull String jvmInfo, @NonNull String installDirectory, @NonNull String agentVersion) {
            if (machineInfo == null) {
                throw new NullPointerException("machineInfo is marked non-null but is null");
            }
            if (jvmInfo == null) {
                throw new NullPointerException("jvmInfo is marked non-null but is null");
            }
            if (installDirectory == null) {
                throw new NullPointerException("installDirectory is marked non-null but is null");
            }
            if (agentVersion == null) {
                throw new NullPointerException("agentVersion is marked non-null but is null");
            }
            this.machineInfo = machineInfo;
            this.jvmInfo = jvmInfo;
            this.installDirectory = installDirectory;
            this.agentVersion = agentVersion;
        }
    }
}

