/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.common.biz.shared.machines;

import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfigType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class AgentMonitorConfig {
    public static final String CONFIG_NAME = "_agentMonitoringConfig";
    private Map<String, String> configurations;

    public AgentMonitorConfig() {
        this.configurations = new HashMap<String, String>();
    }

    @JsonCreator
    public AgentMonitorConfig(@JsonProperty(value="configurations") Map<String, String> configurations) {
        this.configurations = configurations;
    }

    @JsonIgnore
    public Optional<Integer> getSafeMaxProcessClasses() {
        String maxProcessClasses = this.configurations.get(AgentMonitorConfigType.MAX_PROCESS_CLASS.name());
        if (maxProcessClasses == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Integer.valueOf(maxProcessClasses));
    }

    @JsonIgnore
    public boolean isPercentileMonitoringAllowed() {
        return Boolean.parseBoolean(this.configurations.get(AgentMonitorConfigType.PERCENTILE_MONITORING_ALLOWED.name()));
    }

    @JsonIgnore
    public Optional<Long> getAwsPollingInterval() {
        String awsPollingInterval = this.configurations.get(AgentMonitorConfigType.AWS_TAGS_POLLING_INTERVAL_CONFIG.name());
        if (awsPollingInterval == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Long.valueOf(awsPollingInterval));
    }

    @JsonIgnore
    public boolean isTagsEnabled() {
        return Boolean.parseBoolean(this.configurations.get(AgentMonitorConfigType.GLOBAL_TAGS_ENABLED.name()));
    }

    @JsonIgnore
    public boolean isAwsTagsEnabled() {
        return Boolean.parseBoolean(this.configurations.get(AgentMonitorConfigType.AWS_TAGS_ENABLED.name()));
    }

    @JsonIgnore
    public boolean isDockerTagsEnabled() {
        return Boolean.parseBoolean(this.configurations.get(AgentMonitorConfigType.DOCKER_TAGS_ENABLED.name()));
    }

    @JsonIgnore
    public boolean isK8sTagsEnabled() {
        return Boolean.parseBoolean(this.configurations.get(AgentMonitorConfigType.K8S_TAGS_ENABLED.name()));
    }

    @JsonIgnore
    public Optional<Long> getK8sPollingInterval() {
        String k8sPollingInterval = this.configurations.get(AgentMonitorConfigType.K8S_TAGS_POLLING_INTERVAL_CONFIG.name());
        if (k8sPollingInterval == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Long.valueOf(k8sPollingInterval));
    }

    @JsonIgnore
    public boolean isAzureTagsEnabled() {
        return Boolean.parseBoolean(this.configurations.get(AgentMonitorConfigType.AZURE_TAGS_ENABLED.name()));
    }

    @JsonIgnore
    public Optional<Long> getAzurePollingInterval() {
        String AzurePollingInterval = this.configurations.get(AgentMonitorConfigType.AZURE_TAGS_POLLING_INTERVAL_CONFIG.name());
        if (AzurePollingInterval == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Long.valueOf(AzurePollingInterval));
    }

    @JsonIgnore
    public boolean isK8sNodeTagsEnabled() {
        return Boolean.parseBoolean(this.configurations.get(AgentMonitorConfigType.K8SNODE_TAGS_ENABLED.name()));
    }

    @JsonIgnore
    public Optional<Long> getK8sNodePollingInterval() {
        String K8sNodePollingInterval = this.configurations.get(AgentMonitorConfigType.K8SNODE_TAGS_POLLING_INTERVAL_CONFIG.name());
        if (K8sNodePollingInterval == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Long.valueOf(K8sNodePollingInterval));
    }

    @JsonIgnore
    public Optional<Integer> getMaxTagsPerMachine() {
        String maxTagsPerMachine = this.configurations.get(AgentMonitorConfigType.MAX_TAGS_PER_MACHINE.name());
        if (maxTagsPerMachine == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Integer.valueOf(maxTagsPerMachine));
    }

    @JsonIgnore
    public Optional<Integer> getContainersLimit() {
        String limitString = this.configurations.get(AgentMonitorConfigType.MACHINE_CONTAINER_LIMIT.name());
        if (limitString == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)Integer.valueOf(limitString));
    }

    @JsonIgnore
    public Optional<Boolean> isMonitorApmContainersOnlyEnabled() {
        String booleanString = this.configurations.get(AgentMonitorConfigType.MONITOR_APM_CONTAINERS_ONLY.name());
        if (booleanString == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)Boolean.valueOf(booleanString));
    }

    @JsonIgnore
    public Optional<Integer> getContainersLimitPerCluster() {
        String limitString = this.configurations.get(AgentMonitorConfigType.CLUSTER_CONTAINER_LIMIT.name());
        if (limitString == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)Integer.valueOf(limitString));
    }

    public static AgentMonitorConfigBuilder builder() {
        return new AgentMonitorConfigBuilder();
    }

    public Map<String, String> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Map<String, String> configurations) {
        this.configurations = configurations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentMonitorConfig)) {
            return false;
        }
        AgentMonitorConfig other = (AgentMonitorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$configurations = this.getConfigurations();
        Map<String, String> other$configurations = other.getConfigurations();
        return !(this$configurations == null ? other$configurations != null : !((Object)this$configurations).equals(other$configurations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgentMonitorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $configurations = this.getConfigurations();
        result = result * 59 + ($configurations == null ? 43 : ((Object)$configurations).hashCode());
        return result;
    }

    public String toString() {
        return "AgentMonitorConfig(configurations=" + this.getConfigurations() + ")";
    }

    public static class AgentMonitorConfigBuilder {
        private ArrayList<String> configurations$key;
        private ArrayList<String> configurations$value;

        AgentMonitorConfigBuilder() {
        }

        public AgentMonitorConfigBuilder configuration(String configurationKey, String configurationValue) {
            if (this.configurations$key == null) {
                this.configurations$key = new ArrayList();
                this.configurations$value = new ArrayList();
            }
            this.configurations$key.add(configurationKey);
            this.configurations$value.add(configurationValue);
            return this;
        }

        public AgentMonitorConfigBuilder configurations(Map<? extends String, ? extends String> configurations) {
            if (configurations == null) {
                throw new NullPointerException("configurations cannot be null");
            }
            if (this.configurations$key == null) {
                this.configurations$key = new ArrayList();
                this.configurations$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : configurations.entrySet()) {
                this.configurations$key.add($lombokEntry.getKey());
                this.configurations$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public AgentMonitorConfigBuilder clearConfigurations() {
            if (this.configurations$key != null) {
                this.configurations$key.clear();
                this.configurations$value.clear();
            }
            return this;
        }

        public AgentMonitorConfig build() {
            Map<String, String> configurations;
            switch (this.configurations$key == null ? 0 : this.configurations$key.size()) {
                case 0: {
                    configurations = Collections.emptyMap();
                    break;
                }
                case 1: {
                    configurations = Collections.singletonMap(this.configurations$key.get(0), this.configurations$value.get(0));
                    break;
                }
                default: {
                    configurations = new LinkedHashMap<String, String>(this.configurations$key.size() < 0x40000000 ? 1 + this.configurations$key.size() + (this.configurations$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.configurations$key.size(); ++$i) {
                        configurations.put(this.configurations$key.get($i), this.configurations$value.get($i));
                    }
                    configurations = Collections.unmodifiableMap(configurations);
                }
            }
            return new AgentMonitorConfig(configurations);
        }

        public String toString() {
            return "AgentMonitorConfig.AgentMonitorConfigBuilder(configurations$key=" + this.configurations$key + ", configurations$value=" + this.configurations$value + ")";
        }
    }
}

