/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.common.biz.shared.constants;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum AgentType {
    APP_AGENT,
    MACHINE_AGENT,
    DOT_NET_APP_AGENT,
    DOT_NET_MACHINE_AGENT,
    PHP_APP_AGENT,
    PHP_MACHINE_AGENT,
    NODEJS_APP_AGENT,
    NODEJS_MACHINE_AGENT,
    PYTHON_APP_AGENT,
    NATIVE_APP_AGENT,
    NATIVE_SDK,
    NATIVE_DYNAMIC,
    NATIVE_WEB_SERVER,
    DB_AGENT,
    DB_COLLECTOR,
    RUBY_APP_AGENT,
    SIM_MACHINE_AGENT,
    APM_MACHINE_AGENT,
    SERVICE_AVAIL_MACHINE_AGENT,
    APM_APP_AGENT,
    ANALYTICS_AGENT,
    GOLANG_SDK,
    WMB_AGENT,
    NETVIZ_AGENT;

    public static final Set<AgentType> AGENT_TYPES_FOR_LICENSING;
    public static final Set<AgentType> AGENT_TYPES_VISIBLE_IN_UI;
    public static final String FAAS = "faas";
    public static final String FAAS_LAMBDA_JAVA = "faas_lambda_java";
    public static final String FAAS_LAMBDA_NODEJS = "faas_lambda_nodejs";

    public static AgentType valueOf(int val) {
        switch (val) {
            case 0: {
                return APP_AGENT;
            }
            case 1: {
                return MACHINE_AGENT;
            }
            case 2: {
                return DOT_NET_APP_AGENT;
            }
            case 3: {
                return DOT_NET_MACHINE_AGENT;
            }
            case 4: {
                return PHP_APP_AGENT;
            }
            case 5: {
                return PHP_MACHINE_AGENT;
            }
            case 6: {
                return NODEJS_APP_AGENT;
            }
            case 7: {
                return NODEJS_MACHINE_AGENT;
            }
            case 8: {
                return PYTHON_APP_AGENT;
            }
            case 9: {
                return NATIVE_APP_AGENT;
            }
            case 10: {
                return NATIVE_SDK;
            }
            case 11: {
                return NATIVE_DYNAMIC;
            }
            case 12: {
                return NATIVE_WEB_SERVER;
            }
            case 13: {
                return DB_AGENT;
            }
            case 14: {
                return DB_COLLECTOR;
            }
            case 15: {
                return RUBY_APP_AGENT;
            }
            case 16: {
                return SIM_MACHINE_AGENT;
            }
            case 17: {
                return APM_MACHINE_AGENT;
            }
            case 18: {
                return SERVICE_AVAIL_MACHINE_AGENT;
            }
            case 19: {
                return APM_APP_AGENT;
            }
            case 20: {
                return ANALYTICS_AGENT;
            }
            case 21: {
                return GOLANG_SDK;
            }
            case 22: {
                return WMB_AGENT;
            }
        }
        throw new IllegalArgumentException("Invalid value: " + val);
    }

    private static boolean contains(String type) {
        for (AgentType agentType : AgentType.values()) {
            if (!type.equalsIgnoreCase(agentType.name())) continue;
            return true;
        }
        return false;
    }

    public static AgentType[] getAllAppAgents() {
        return new AgentType[]{DOT_NET_APP_AGENT, APP_AGENT, NATIVE_APP_AGENT, NATIVE_SDK, NATIVE_DYNAMIC, NATIVE_WEB_SERVER, NODEJS_APP_AGENT, PHP_APP_AGENT, PYTHON_APP_AGENT, RUBY_APP_AGENT, APM_APP_AGENT, GOLANG_SDK, WMB_AGENT};
    }

    public static Set<AgentType> getAllAppAgentsVisibleInUI() {
        return AGENT_TYPES_VISIBLE_IN_UI;
    }

    public static String buildString(String[] agentTypes, String delim) {
        if (agentTypes == null || agentTypes.length == 0) {
            throw new IllegalArgumentException("Null or empty AgentTypes specified");
        }
        StringBuilder sb = new StringBuilder();
        for (String agentType : agentTypes) {
            if (!AgentType.contains(agentType)) {
                throw new IllegalArgumentException("Invalid AgentType specified : " + agentType);
            }
            sb.append(delim + agentType);
        }
        return sb.substring(1);
    }

    static {
        HashSet<AgentType> agentTypes = new HashSet<AgentType>();
        block3: for (AgentType agentType : AgentType.values()) {
            switch (agentType) {
                case DOT_NET_MACHINE_AGENT: 
                case NODEJS_MACHINE_AGENT: 
                case PHP_MACHINE_AGENT: 
                case APM_MACHINE_AGENT: 
                case NATIVE_DYNAMIC: 
                case NATIVE_APP_AGENT: 
                case RUBY_APP_AGENT: 
                case ANALYTICS_AGENT: {
                    continue block3;
                }
                default: {
                    agentTypes.add(agentType);
                }
            }
        }
        AGENT_TYPES_FOR_LICENSING = Collections.unmodifiableSet(agentTypes);
        HashSet<AgentType> agentTypeSetVisibleToUI = new HashSet<AgentType>();
        agentTypeSetVisibleToUI.add(DOT_NET_APP_AGENT);
        agentTypeSetVisibleToUI.add(APP_AGENT);
        agentTypeSetVisibleToUI.add(NATIVE_WEB_SERVER);
        agentTypeSetVisibleToUI.add(NODEJS_APP_AGENT);
        agentTypeSetVisibleToUI.add(PHP_APP_AGENT);
        agentTypeSetVisibleToUI.add(PYTHON_APP_AGENT);
        agentTypeSetVisibleToUI.add(APM_APP_AGENT);
        AGENT_TYPES_VISIBLE_IN_UI = Collections.unmodifiableSet(agentTypeSetVisibleToUI);
    }
}

