/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.api.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Paths;
import lombok.NonNull;

@Singleton
public class EasyFileReaderUtils {
    public boolean isNonEmptyDirectory(@NonNull String basePath, String ... more) {
        if (basePath == null) {
            throw new NullPointerException("basePath is marked non-null but is null");
        }
        File file = this.getFile(basePath, more);
        return file != null && file.exists() && file.isDirectory() && file.list() != null && file.list().length > 0;
    }

    @VisibleForTesting
    File getFile(String basePath, String ... more) {
        return Paths.get(basePath, more).toFile();
    }
}

