/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.api.rawdata;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataErrorHandler;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataNumber;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import lombok.Generated;
import lombok.NonNull;

public class RawDataLong
implements RawDataNumber<Long, RawDataLong> {
    private final Optional<Long> value;
    private final String error;
    private final RawDataFactory factory;
    private final RawDataErrorHandler errorHandler;

    @VisibleForTesting
    public RawDataLong(@NonNull RawDataFactory factory, @NonNull RawDataErrorHandler errorHandler, @NonNull Optional<Long> value, @NonNull String error) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
        this.factory = factory;
        this.errorHandler = errorHandler;
        this.value = value;
        this.error = error;
    }

    @AssistedInject
    private RawDataLong(@NonNull RawDataFactory factory, @NonNull RawDataErrorHandler errorHandler, @Assisted @NonNull Long value) {
        this(factory, errorHandler, (Optional<Long>)Optional.of((Object)value), "");
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    @AssistedInject
    private RawDataLong(@NonNull RawDataFactory factory, @NonNull RawDataErrorHandler errorHandler, @Assisted @NonNull String error) {
        this(factory, errorHandler, (Optional<Long>)Optional.absent(), error);
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler is marked non-null but is null");
        }
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
    }

    @Override
    public Long get() {
        if (this.value.isPresent()) {
            return (Long)this.value.get();
        }
        throw new IllegalStateException("The value was not present");
    }

    @Override
    public Long or(@NonNull Long defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        if (this.value.isPresent()) {
            return (Long)this.value.get();
        }
        return defaultValue;
    }

    @Override
    public boolean isPresent() {
        return this.value.isPresent();
    }

    @Override
    public RawDataLong add(@NonNull RawDataLong item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (this.errorHandler.isValidInput(this, item)) {
            long newValue = (Long)this.getValue().get() + (Long)item.getValue().get();
            return this.factory.createLong(newValue);
        }
        return this.newLongWithError(item);
    }

    @Override
    public RawDataLong subtract(@NonNull RawDataLong item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (this.errorHandler.isValidInput(this, item)) {
            long newValue = (Long)this.getValue().get() - (Long)item.getValue().get();
            return this.factory.createLong(newValue);
        }
        return this.newLongWithError(item);
    }

    @Override
    public RawDataLong multiply(@NonNull RawDataLong item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (this.errorHandler.isValidInput(this, item)) {
            long newValue = (Long)this.getValue().get() * (Long)item.getValue().get();
            return this.factory.createLong(newValue);
        }
        return this.newLongWithError(item);
    }

    @Override
    public RawDataLong divide(@NonNull RawDataLong item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (this.errorHandler.isValidInput(this, item)) {
            if ((Long)item.getValue().get() == 0L) {
                return this.newLongWithError("Tried to divide by 0");
            }
            long newValue = (Long)this.getValue().get() / (Long)item.getValue().get();
            return this.factory.createLong(newValue);
        }
        return this.newLongWithError(item);
    }

    private RawDataLong newLongWithError(RawDataLong item) {
        return this.factory.createLong(this.errorHandler.aggregateErrorStrings(this, item));
    }

    private RawDataLong newLongWithError(String error) {
        return this.factory.createLong(error);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawDataLong)) {
            return false;
        }
        RawDataLong other = (RawDataLong)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<Long> this$value = this.getValue();
        Optional<Long> other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RawDataLong;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Long> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RawDataLong(value=" + String.valueOf(this.getValue()) + ", error=" + this.getError() + ")";
    }

    @Generated
    public Optional<Long> getValue() {
        return this.value;
    }

    @Override
    @Generated
    public String getError() {
        return this.error;
    }
}

