/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.version;

import com.singularity.ee.util.io.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class JavaAgentBinaryManager {
    private static final long AGENT_MIN_TIME_BETWEEN_SCANS = 600000L;
    protected final File javaBinaryDirectory = this.getJavaAgentBinariesDir();
    protected final File javaInstallDirectory = this.getJavaInstallDir();
    protected String[] agentVersions;
    private long lastTimeAgentDirectoryScanned;
    private static final Pattern fileNamePattern = Pattern.compile("app-server-agent-obfuscated-.*\\.zip");
    private static final String OBFUSCATED_PART = "obfuscated-";

    protected JavaAgentBinaryManager() {
    }

    public abstract File getJavaAgentBinariesDir();

    public File getJavaInstallDir() {
        return null;
    }

    public String[] getAgentVersions() {
        long currentTime = System.currentTimeMillis();
        if (this.agentVersions == null || currentTime - this.lastTimeAgentDirectoryScanned > 600000L) {
            File[] filesInJavaInstallDir;
            File[] filesInDir;
            HashSet<String> setOfAllAgentVersions = new HashSet<String>();
            if (this.javaInstallDirectory == null && this.javaBinaryDirectory != null && this.javaBinaryDirectory.isDirectory() && (filesInDir = this.javaBinaryDirectory.listFiles()) != null) {
                for (File nextFile : filesInDir) {
                    String fileName;
                    Matcher matcher;
                    if (nextFile.isDirectory() || !(matcher = fileNamePattern.matcher(fileName = nextFile.getName())).matches()) continue;
                    int index = fileName.indexOf(OBFUSCATED_PART);
                    String versionNum = fileName.substring(index + OBFUSCATED_PART.length(), fileName.length() - 4);
                    setOfAllAgentVersions.add(versionNum);
                }
            }
            if (this.javaInstallDirectory != null && this.javaInstallDirectory.isDirectory() && (filesInJavaInstallDir = this.javaInstallDirectory.listFiles()) != null) {
                for (File nextFile : filesInJavaInstallDir) {
                    if (!nextFile.isDirectory() || !nextFile.getName().startsWith("ver")) continue;
                    setOfAllAgentVersions.add(nextFile.getName().substring(3));
                }
            }
            this.agentVersions = setOfAllAgentVersions.toArray(new String[setOfAllAgentVersions.size()]);
            this.lastTimeAgentDirectoryScanned = currentTime;
        }
        return this.agentVersions;
    }

    public String[] getAgentVersionsNotInstalled(String[] versionsToTest) {
        Set<String> setOfAgentVersions = this.getAgentVersionsAsSet();
        ArrayList<String> listOfMissingVersions = new ArrayList<String>();
        for (String nextVersionToTest : versionsToTest) {
            if (setOfAgentVersions.contains(nextVersionToTest)) continue;
            listOfMissingVersions.add(nextVersionToTest);
        }
        String[] returnMissingVersions = null;
        if (listOfMissingVersions.size() > 0) {
            returnMissingVersions = listOfMissingVersions.toArray(new String[listOfMissingVersions.size()]);
        }
        return returnMissingVersions;
    }

    private Set<String> getAgentVersionsAsSet() {
        this.getAgentVersions();
        HashSet<String> returnSet = new HashSet<String>(this.agentVersions.length);
        for (String nextAgentVersion : this.agentVersions) {
            returnSet.add(nextAgentVersion);
        }
        return returnSet;
    }

    public void unzipAgentBinaryToDir(File sourceFile, File targetDirectory, boolean shouldDeleteSource) {
        if (!sourceFile.exists() || sourceFile.isDirectory()) {
            throw new RuntimeException(String.format("File %s does not exist in %s or is a directory", sourceFile.getAbsolutePath(), this.javaBinaryDirectory.getAbsolutePath()));
        }
        try {
            ZipFile zipFile = new ZipFile(sourceFile);
            this.unzipFileToDir(zipFile, targetDirectory);
            if (shouldDeleteSource) {
                sourceFile.delete();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void unzipFileToDir(ZipFile zipFile, File targetDirectory) throws IOException {
        Enumeration<? extends ZipEntry> zipEnum = zipFile.entries();
        while (zipEnum.hasMoreElements()) {
            ZipEntry zipEntry = zipEnum.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().startsWith(targetDirectory.getName())) continue;
            this.copyZipEntryToDir(zipEntry, zipFile, targetDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyZipEntryToDir(ZipEntry zipEntry, ZipFile zipFile, File targetDirectory) throws IOException {
        InputStream is = zipFile.getInputStream(zipEntry);
        String originalName = zipEntry.getName();
        String sanitizedFileName = this.sanitizeFileName(originalName);
        File outputFile = new File(targetDirectory, sanitizedFileName);
        if (!outputFile.getCanonicalPath().startsWith(targetDirectory.getCanonicalPath() + File.separator)) {
            throw new IOException("Invalid file path: " + outputFile.getCanonicalPath());
        }
        outputFile.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            IOUtils.copy(is, fos);
        }
        finally {
            is.close();
        }
    }

    private String sanitizeFileName(String fileName) {
        return fileName.replace("..", "").replace("/", File.separator).replace("\\", File.separator);
    }

    public static String createZippedAgentFileName(String versionNumber) {
        return String.format("app-server-agent-obfuscated-%s.zip", versionNumber);
    }
}

